% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_extract.R
\name{regression.diagnostic.cmp}
\alias{regression.diagnostic.cmp}
\alias{influence.cmp}
\alias{hatvalues.cmp}
\alias{rstandard.cmp}
\alias{cooks.distance.cmp}
\title{CMP Regression Diagnostic}
\usage{
\method{influence}{cmp}(model, ...)

\method{hatvalues}{cmp}(model, ...)

\method{rstandard}{cmp}(
  model,
  infl = influence.cmp(model),
  type = c("deviance", "pearson"),
  ...
)

\method{cooks.distance}{cmp}(
  model,
  infl = influence(model),
  res = infl$pear_res,
  hat = infl$hat,
  ...
)
}
\arguments{
\item{model}{an object class 'cmp', obtained from a call to \code{\link{glm.cmp}}.}

\item{...}{other arguments passed to or from other methods  (currently unused).}

\item{infl}{influence structure as returned by \code{\link{influence}}, only for  \code{\link{rstudent}} and \code{\link{cooks.distance}}.}

\item{type}{type of residuals for \code{\link{rstandard}}. The alternatives are: 'deviance' (default), and 'pearson'.}

\item{res}{residuals, with proper default.}

\item{hat}{hat values \eqn{H[i,i]}, see default.}
}
\description{
This suite of functions provides the basic quantities which are used in forming a wide variety of diagnostics for checking the quality of regression fits.
}
\examples{
data(attendance)
M.attendance <- glm.cmp(daysabs~ gender+math+prog, data=attendance)
influence(M.attendance)
hatvalues(M.attendance)
rstandard(M.attendance, type = "pearson")
cooks.distance(M.attendance)
}
