% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical.R
\name{compare_avg_power2}
\alias{compare_avg_power2}
\title{Compare the average power distribution of two SplicedViews using sampling on
each segment}
\usage{
compare_avg_power2(
  sv1,
  sv2,
  name1,
  name2,
  num_samples,
  column,
  show_plot = TRUE
)
}
\arguments{
\item{sv1}{\code{SplicedView} object.}

\item{sv2}{\code{SplicedView} object.}

\item{name1}{name for first object.}

\item{name2}{name for second object.}

\item{num_samples}{number of samples to draw from segments.}

\item{column}{column name in the data e.g. 'Nose_x_Central_Sitar'.}

\item{show_plot}{show the plot?}
}
\value{
list of two data.frames containing the sampled data.
}
\description{
Compare the average power distribution of two SplicedViews using sampling on
each segment
}
\examples{
r <- get_sample_recording()
d1 <- get_duration_annotation_data(r)
fv_list <- get_filtered_views(r, data_points = "Nose", n = 41, p = 3)
jv <- get_joined_view(fv_list)

# only one relevant section for sample data
splicing_smile_df <- splice_time(d1, tier ='INTERACTION',
  comments = 'Mutual look and smile')
sv_duration_smile <- get_spliced_view(jv, splicing_df = splicing_smile_df)

splicing_alap_df <- splice_time(
  d1, tier = 'FORM', comments = 'Alap'
)
sv_duration_alap <- get_spliced_view(jv, splicing_df = splicing_alap_df)

sample_list <- compare_avg_power2(
sv_duration_smile, sv_duration_alap, 'Smile', 'Alap', num_samples = 100,
  column = "Nose_x_Central_Sitar")
}
\seealso{
Other statistical and analysis functions: 
\code{\link{apply_column_spliceview}()},
\code{\link{apply_segment_spliceview}()},
\code{\link{ave_cross_power_over_splices}()},
\code{\link{ave_cross_power_spliceview}()},
\code{\link{ave_power_over_splices}()},
\code{\link{ave_power_spliceview}()},
\code{\link{calculate_ave_cross_power1}()},
\code{\link{calculate_ave_power1}()},
\code{\link{compare_ave_cross_power1}()},
\code{\link{compare_ave_power1}()},
\code{\link{compare_avg_cross_power2}()},
\code{\link{difference_onsets}()},
\code{\link{pull_segment_spliceview}()},
\code{\link{sample_gap_splice}()},
\code{\link{sample_offset_splice}()},
\code{\link{summary_onsets}()},
\code{\link{visualise_sample_splices}()}
}
\concept{statistical and analysis functions}
