% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotPR.R
\name{plotPR}
\alias{plotPR}
\title{Plot pseudo-residuals}
\usage{
plotPR(m)
}
\arguments{
\item{m}{A \code{\link{moveHMM}} object}
}
\description{
Plots time series, qq-plots (against the standard normal distribution), and sample
ACF functions of the pseudo-residuals
}
\details{
If some turning angles in the data are equal to pi, the corresponding pseudo-residuals
will not be included. Indeed, given that the turning angles are defined on (-pi,pi], an angle of pi
results in a pseudo-residual on +Inf (check Section 6.2 of reference for more information on the
computation of pseudo-residuals).
}
\examples{
# m is a moveHMM object (as returned by fitHMM), automatically loaded with the package
m <- example$m

plotPR(m)
}
\references{
Zucchini, W. and MacDonald, I.L. 2009.
Hidden Markov Models for Time Series: An Introduction Using R.
Chapman & Hall (London).
}

