% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customnsga2.R
\name{slickEvaluateFitness}
\alias{slickEvaluateFitness}
\title{Compute the Fitness of Individuals}
\usage{
slickEvaluateFitness(ctrl, population, fidelity = NULL, previous.points = NULL)
}
\arguments{
\item{ctrl}{\verb{[ecr_control]} control object.}

\item{population}{\verb{[list]} list of individuals to evaluate.}

\item{fidelity}{\verb{[numeric]} vector of fidelity, with one
or two elements. If this has one element, it is directly
passed on to the fitness function. If it has two elements,
the fitness function is first evaluated with the first
fidelity; if the resulting point dominates the population
given in \code{population} it is again evaluated with the
second fidelity given, and the result is averaged weighted
by the fidelity parameter.}

\item{previous.points}{\verb{[matrix]} population to compare points
to if \code{fidelity} has two elements. Otherwise not used.}
}
\value{
\code{list(population = list, fitness = matrix)}
}
\description{
Takes a list of individuals \code{population} and evaluates the fitness
with varying \code{fidelity}, if specified.

A list is returned with two elements, one being the list of individuals and
one being the matrix of fitness values. In the matrix each column represents
the fitness values of one individual.
For consistency, a matrix is also returned for single objective fitness function.
}
