% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_effect.R
\name{mod_effect}
\alias{mod_effect}
\title{Calculate effect sizes in a model}
\usage{
mod_effect(model, formula, step = NULL, bootstrap = 0, to = step,
  nlevels = 1, data = NULL, at = NULL, class_level = NULL, ...)
}
\arguments{
\item{model}{the model from which the effect size is to be calculated}

\item{formula}{a formula whose right-hand side is the variable with respect
to which the effect size is to be calculated.}

\item{step}{the numerical stepsize for the change var, or a comparison category
for a categorical change var. This will be either a character string or a number,
depending on the type of variable specified in the formula.}

\item{bootstrap}{The number of bootstrap replications to construct.
If greater than 1, calculate a standard error using that number of replications.}

\item{to}{a synonym for step. (In English, "to" is more appropriate for a
categorical input, "step" for a quantitative. But you can use either.)}

\item{nlevels}{integer specifying the number of levels to use for "typical" inputs. (Default: up to 3)}

\item{data}{Specifies exactly the cases at which you want to calculate the effect size.}

\item{at}{similar to \code{...} but expects a list or dataframe of the values you want to set.
Like \code{...}, all combinations of the values specified will be used as inputs.}

\item{class_level}{Name of the categorical level for which the probability is to be used. Applies
only to classifiers. (Default: Use the first level.)
Unlike \code{...} or \code{at}, no new combinations will be created.}

\item{...}{additional arguments for evaluation levels of explanatory
variables.}
}
\value{
a data frame giving the effect size and the values of the explanatory variables at which
the effect size was calculated. There will also be a column \code{to_} showing the value jumped to for the
variable with respect to which the effect size is calculated. When \code{bootstrap} is greater than 1, there will
be a standard error reported on the effect size; see the variable ending in \code{_se}.
}
\description{
Like a derivative or finite-difference
}
\details{
When you want to force or restrict the effect size calculation to specific values for
explanatory variables, list those variables and levels as a vector in ...
For example, \code{educ = c(10, 12, 16)} will cause the effect size to be calculated
at each of those three levels of education. Any variables whose levels are not specified in
... will have values selected automatically.
}
\examples{
mod1 <- lm(wage ~ age * sex * educ + sector, data = mosaicData::CPS85)
mod_effect(mod1, ~ sex)
mod_effect(mod1, ~ sector)
mod_effect(mod1, ~ age, sex = "M", educ = c(10, 12, 16), age = c(30, 40))
mod_effect(mod1, ~ age, sex = "F", age = 34, step = 1)
mod_effect(mod1, ~ sex, age = 35, sex = "M", to = "F" )
# For classifiers, the change in *probability* of a level is reported.
mod2 <- rpart::rpart(sector ~ age + sex + educ + wage, data = mosaicData::CPS85)
mod_effect(mod2, ~ educ)
mod_effect(mod2, ~ educ, class_level = "manag")
}
