% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tally.R
\name{prop}
\alias{prop}
\alias{prop1}
\alias{count}
\alias{perc}
\title{Compute proportions, percents, or counts for a single level}
\usage{
prop(x, data = parent.frame(), useNA = "no", ..., success = NULL,
  level = NULL, long.names = TRUE, sep = ".", format = c("proportion",
  "percent", "count"), quiet = TRUE, pval.adjust = FALSE)

prop1(..., pval.adjust = TRUE)

count(x, ...)

perc(x, data = parent.frame(), ..., format = "percent")
}
\arguments{
\item{x}{an R object, usually a formula}

\item{data}{a data frame in which \code{x} is to be evaluated}

\item{useNA}{an indication of how NA's should be handled.  By default, they are
ignored.}

\item{\dots}{arguments passed through to \code{\link[=tally]{tally()}}}

\item{success}{the level for which counts, proportions or percents are
calculated}

\item{level}{Depricated.  Use \code{sucess}.}

\item{long.names}{a logical indicating whether long names should be
when there is a conditioning variable}

\item{sep}{a character used to separate portions of long names}

\item{format}{one of \code{proportion}, \code{percent}, or \code{count},
possibly abbrevaited}

\item{quiet}{a logical indicating whether messages regarding the
success level should be supressed.}

\item{pval.adjust}{a logical indicating whether the "p-value" adjustment should be
applied.  This adjustment adds 1 to the numerator and denominator counts.}
}
\description{
Compute proportions, percents, or counts for a single level
}
\details{
\code{prop1} is intended for the computation of p-values from randomization
distributions and differs from \code{prop} only in its default value of
\code{pval.adjust}.
}
\note{
For 0-1 data, \code{success} is set to 1 by default since that a standard
coding scheme for success and failure.
}
\examples{
prop( ~sex, data=HELPrct)
prop( ~sex, data=HELPrct, success = "male")
count( ~sex | substance, data=HELPrct)
prop( ~sex | substance, data=HELPrct)
perc( ~sex | substance, data=HELPrct)
}
