% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.reproData.R
\name{plot.reproData}
\alias{plot.reproData}
\title{Plotting method for \code{reproData} objects}
\usage{
\method{plot}{reproData}(x, xlab, ylab = "Cumulated Number of offspring",
  main = NULL, target.time = NULL, concentration = NULL,
  style = "generic", pool.replicate = FALSE, log.scale = FALSE,
  addlegend = FALSE, remove.someLabels = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{reproData}}

\item{xlab}{a title for the \eqn{x}-axis (optional)}

\item{ylab}{a title for the \eqn{y}-axis}

\item{main}{main title for the plot}

\item{target.time}{a numeric value corresponding to some observed time in \code{data}}

\item{concentration}{a numeric value corresponding to some concentration in \code{data}}

\item{style}{graphical backend, can be \code{'generic'} or \code{'ggplot'}}

\item{pool.replicate}{if \code{TRUE}, the datapoints of each replicate are
summed for a same concentration}

\item{log.scale}{if \code{TRUE}, displays \eqn{x}-axis in log-scale}

\item{addlegend}{if \code{TRUE}, adds a default legend to the plot}

\item{remove.someLabels}{if \code{TRUE}, removes 3/4 of X-axis labels in
\code{'ggplot'} style to avoid the label overlap}

\item{\dots}{Further arguments to be passed to generic methods.}
}
\description{
Plots the cumulated number of offspring as a
function of either time and concentration, time only (for a fixed
concentration), concentration only (for a given target time). If both
concentration and target time are fixed, the function additionally plots
the experimental values for the minimum available concentration.
}
\note{
When \code{style = "ggplot"}, the function calls package
\code{\link[ggplot2]{ggplot2}} and returns an object of class \code{ggplot}.
}
\examples{

library(ggplot2)

# (1) Load the data
data(cadmium1)
cadmium1 <- reproData(cadmium1)

# (2) Plot the reproduction data
plot(cadmium1)

# (3) Plot the reproduction data for a fixed time with a ggplot style
plot(cadmium1, target.time = 21, style = "ggplot")

# (4) Plot the reproduction data for a fixed concentration
plot(cadmium1, concentration = 4.36, style = "ggplot")

# (5) Plot the reproduction data for a fixed concentration and target.time
plot(cadmium1, target.time = 21, concentration = 0.86)

}
\keyword{plot}

