% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphomapPic.R
\name{morphomapPic}
\alias{morphomapPic}
\title{morphomapPic}
\usage{
morphomapPic(morphomap.core, morphomap.shape, vector = NULL,
  full = TRUE, width = 1500, height = 1500, pointsize = 12,
  res = 300, dirpath = tempdir())
}
\arguments{
\item{morphomap.core}{list: morphomap.core object}

\item{morphomap.shape}{list: morphomap.shape object}

\item{vector}{numeric: define which sections will be saved}

\item{full}{logical: if TRUE the thickness at ALPM is reported}

\item{width}{numeric: width of the picture}

\item{height}{numeric: height of the picture}

\item{pointsize}{numeric: pointsize of plotted text}

\item{res}{numeric: the nominal resolution in ppi which will be recorded}

\item{dirpath}{character: path of the directory where the pictures will be saved}
}
\description{
Save the sections defined via morphomapShape or morphomapCore
}
\examples{
\donttest{
#export picture from a human femur bone
data(HomFem38023)
meshes<-morphomapSegm(HomFem38023)
perMesh<-meshes$external
endMesh<-meshes$internal
mech_length<-380.23
rawSections<-morphomapCore(out.sur=perMesh,
                           inn.sur=endMesh,num.sect=11,mech.len = mech_length, 
                           start = 0.2,end=0.8)
shapeSections<-morphomapShape(rawSections,250,sects_vector=NULL,cent.out="CCA",delta=0.5)
morphomapPic(rawSections,shapeSections,full=TRUE,dirpath=tempdir(),
            width=2500,height=2500)

#export picture from a chimpanzee femur bone
data(PanFem27713)
meshes<-morphomapSegm(PanFem27713)
perMesh<-meshes$external
endMesh<-meshes$internal
mech_length<-277.13
rawSections<-morphomapCore(out.sur=perMesh,
                           inn.sur=endMesh,num.sect=11,mech.len = mech_length, 
                           start = 0.2,end=0.8)
shapeSections<-morphomapShape(rawSections,250,sects_vector=NULL,cent.out="CCA",delta=0.5)
morphomapPic(rawSections,shapeSections,full=TRUE,dirpath=tempdir(),
             width=2500,height=2500)
}
}
\author{
Antonio Profico, Luca Bondioli, Pasquale Raia, Paul O'Higgins, Damiano Marchi
}
