% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-s3.R
\name{summary.morf.marginal}
\alias{summary.morf.marginal}
\title{Summary Method for morf.marginal Objects}
\usage{
\method{summary}{morf.marginal}(object, latex = FALSE, ...)
}
\arguments{
\item{object}{An \code{morf.marginal} object.}

\item{latex}{If \code{TRUE}, prints LATEX code.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Summarizes an \code{morf.marginal} object.
}
\description{
Summarizes an \code{morf.marginal} object.
}
\details{
Compilation of the LATEX code requires the following packages: \code{booktabs}, \code{float}, \code{adjustbox}. If
standard errors have been estimated, they are printed in parenthesis below each point estimate.
}
\examples{
## Load data from orf package.
set.seed(1986)

library(orf)
data(odata)
odata <- odata[1:200, ] # Subset to reduce elapsed time.

y <- as.numeric(odata[, 1])
X <- as.matrix(odata[, -1])

## Fit morf. Use large number of trees.
forests <- morf(y, X, n.trees = 4000)

## Marginal effects at the mean.
me <- marginal_effects(forests, eval = "atmean")
summary(me)
summary(me, latex = TRUE)

\donttest{
## Add standard errors.
honest_forests <- morf(y, X, n.trees = 4000, honesty = TRUE)
honest_me <- marginal_effects(honest_forests, eval = "atmean", inference = TRUE)
summary(honest_me, latex = TRUE)}

}
\seealso{
\code{\link{morf}}, \code{\link{marginal_effects}}.
}
\author{
Riccardo Di Francesco
}
