% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modygliani.R
\name{modygliani}
\alias{modygliani}
\title{modygliani: MOlecular DYnamics GLobal ANalysis}
\usage{
modygliani(path, names, tauGuess, miniRMSD, maxiRMSD, miniEne, maxiEne, YFlag,
  title, colors)
}
\arguments{
\item{path}{A string containing the path to the properly formatted ASCII files. NAMD file style have to be composed of 3 columns including time, RMSD and Energy. Yasara styles are as the standard output.}

\item{names}{A vector of strings containing the names of the peptides/proteins to compare. The number of files to analyze have to correspond to the length of this vector and vice versa. File names cannot contain an extension.}

\item{tauGuess}{A numerical value containing the time constant that is guessed by the user. tayGuess is a useful parameter when fitting fails. If tauGuess is to 0, Modygliani guesses tau in order to attempt fittings.}

\item{miniRMSD}{A numerical value corresponding to the minimum value of RMSD}

\item{maxiRMSD}{A numerical value corresponding to the maximum value of RMSD}

\item{miniEne}{A numerical value corresponding to the minimum value of Energy}

\item{maxiEne}{A numerical value corresponding to the maximum value of Energy}

\item{YFlag}{A 1|0 numerical value. The values are 1 for Yasara dynamics and 0 for NAMD}

\item{title}{A string containing the title of the charts}

\item{colors}{A vector of strings containing color shades, see the example for further details}
}
\description{
Modygliani performs a fitting of the RMSD trajectories. Internal energies are analyzed on the basis of the RMSD fitting. This process is iterated as many times as the number of files provided. Modygliani allows for the comparison of different trajectories. See the references for further information. Example input files are in 'inst/extdata/'.Example output files are stored in 'inst/extdata/output'.
}
\examples{
## fitting and comparison of four different MD trajectories
names <- c("fe_CG","co_CG","ni_CG","zn_CG") # file names
colors<- c("gray0","gray25","gray50","gray75")
path <-"inst/extdata/"
modygliani(path, names, 0, 0, 8, -200, 250, 0, "Modygliani example on NAMD trajectories", colors)
}
\author{
Luca Belmonte, Sheref S. Mansy
}
\references{
Belmonte, L. Rossetto, D. Forlin, M. Scintilla, S. Bonfio, C. Mansy, S. S. "Cysteine containing dipeptides show a metal specificity that matches the composition of seawater" Phys. Chem. Chem. Phys., 2016, DOI: 10.1039/C6CP00608F
}

