% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rep_sample_n.R
\name{rep_sample_n}
\alias{rep_sample_n}
\title{Repeating sampling.}
\source{
\url{https://github.com/OpenIntroOrg/oilabs-r-package/blob/master/R/rep_sample_n.R}
}
\usage{
rep_sample_n(tbl, size, replace = FALSE, reps = 1)
}
\arguments{
\item{tbl}{tbl of data.}

\item{size}{The number of rows to select.}

\item{replace}{Sample with or without replacement?}

\item{reps}{The number of samples to collect.}
}
\value{
A tbl_df that aggregates all created samples, with the addition of a \code{replicate} column that the tbl_df is also grouped by
}
\description{
Repeating sampling.
}
\examples{
library(dplyr)
library(ggplot2)
N <- 2400
tub <- data_frame(
ball_ID = 1:N,
color = c(rep("red", 900), rep("white", N-900))
)

p_hats <- tub \%>\%
rep_sample_n(size=50, reps=10) \%>\% 
group_by(replicate) \%>\% 
summarize(prop_red = mean(color == "red"))

ggplot(p_hats, aes(x = prop_red)) + 
    geom_histogram(binwidth = 0.05)
}
