% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers-modeltime_table.R
\name{add_modeltime_model}
\alias{add_modeltime_model}
\title{Add a Model into a Modeltime Table}
\usage{
add_modeltime_model(object, model, location = "bottom")
}
\arguments{
\item{object}{Multiple Modeltime Tables (class \code{mdl_time_tbl})}

\item{model}{A model of class \code{model_fit} or a fitted \code{workflow} object}

\item{location}{Where to add the model. Either "top" or "bottom". Default: "bottom".}
}
\description{
Add a Model into a Modeltime Table
}
\examples{
\donttest{
library(tidymodels)

model_fit_ets <- exp_smoothing() \%>\%
    set_engine("ets") \%>\%
    fit(value ~ date, training(m750_splits))

m750_models \%>\%
    add_modeltime_model(model_fit_ets)
}

}
\seealso{
\itemize{
\item \code{\link[=combine_modeltime_tables]{combine_modeltime_tables()}}: Combine 2 or more Modeltime Tables together
\item \code{\link[=add_modeltime_model]{add_modeltime_model()}}: Adds a new row with a new model to a Modeltime Table
\item \code{\link[=update_modeltime_description]{update_modeltime_description()}}: Updates a description for a model inside a Modeltime Table
\item \code{\link[=update_modeltime_model]{update_modeltime_model()}}: Updates a model inside a Modeltime Table
\item \code{\link[=pull_modeltime_model]{pull_modeltime_model()}}: Extracts a model from a Modeltime Table
}
}
