% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelsummary_wide.R
\name{modelsummary_wide}
\alias{modelsummary_wide}
\title{Beautiful, customizable summaries of statistical models}
\usage{
modelsummary_wide(
  models,
  output = "default",
  fmt = "\%.3f",
  statistic = "std.error",
  statistic_override = NULL,
  statistic_vertical = TRUE,
  conf_level = 0.95,
  stars = FALSE,
  coef_group = NULL,
  coef_map = NULL,
  coef_omit = NULL,
  coef_rename = NULL,
  gof_map = NULL,
  gof_omit = NULL,
  add_rows = NULL,
  title = NULL,
  notes = NULL,
  estimate = "estimate",
  ...
)
}
\arguments{
\item{models}{a single model object or a (potentially named) list of models
to summarize}

\item{output}{filename or object type (string)
\itemize{
  \item Supported filename extensions: .html, .tex, .md, .txt, .png, .jpg.
  \item Supported object types: "default", "html", "markdown", "latex", "data.frame", "gt", "kableExtra", "huxtable", "flextable".
  \item When a file name is supplied to the `output` argument, the table is written immediately to file. If you want to customize your table by post-processing it with functions provided by the `gt` or `kableExtra` packages, you need to choose a different output format (e.g., "gt", "latex", "html", "markdown"), and you need to save the table after post-processing using the `gt::gtsave`, `kableExtra::save_kable`, or `cat` functions.
}}

\item{fmt}{an integer, string, or function which determines how to format numeric values:
\itemize{
  \item integer: the number of digits to keep after the period (`format(round(x, fmt), nsmall=fmt)`)
  \item character: string is passed to the `sprintf` function. '\%.3f' will keep 3 digits after the decimal point with trailing zero. '\%.5f' will keep 5 digits. '\%.3e' will use exponential notation. See `?sprintf` for more options.
  \item function: a function which returns a formatted character string
}}

\item{statistic}{string name of the statistic to include in parentheses
\itemize{
  \item Typical values: "conf.int", "std.error", "statistic", "p.value"
  \item Alternative values: any column name produced by `broom::tidy(model)`
}}

\item{statistic_override}{manually override the uncertainy estimates. This
argument accepts three types of input:
\itemize{
  \item a function or list of functions of length(models) which produce variance-covariance matrices with row and column names equal to the names of your coefficient estimates. For example, `R` supplies the `vcov` function, and the `sandwich` package supplies `vcovHC`, `vcovHAC`, etc.
  \item a list of length(models) variance-covariance matrices with row and column names equal to the names of your coefficient estimates.
  \item a list of length(models) vectors with names equal to the names of your coefficient estimates. Numeric vectors are formatted according to `fmt` and placed in brackets, character vectors printed as given.
}}

\item{statistic_vertical}{TRUE if statistics should be printed below
estimates. FALSE if statistics should be printed beside estimates.}

\item{conf_level}{confidence level to use for confidence intervals}

\item{stars}{to indicate statistical significance
\itemize{
  \item FALSE (default): no significance stars.
  \item TRUE: *=.1, **=.05, ***=.01
  \item Named numeric vector for custom stars such as `c('*' = .1, '+' = .05)`
}}

\item{coef_group}{the name of the coefficient groups to use as columns (NULL
or character). If `coef_group` is NULL, `modelsummary` tries to guess the
correct coefficient group identifier. To be valid, this identifier must be a
column in the data.frame produced by `tidy(model)`. Note: you may have to
load the `broom` or `broom.mixed` package before executing `tidy(model)`.}

\item{coef_map}{named character vector. Values refer to the variable names
that will appear in the table. Names refer to the original term names stored
in the model object, e.g. c("hp:mpg"="hp X mpg") for an interaction term.
Coefficients that are omitted from this vector will be omitted from the
table. The table will be ordered in the same order as this vector.}

\item{coef_omit}{string regular expression. Omits all matching coefficients
from the table (using `grepl(perl=TRUE)`).}

\item{coef_rename}{named character vector. Values refer to the variable names
that will appear in the table. Names refer to the original term names stored
in the model object, e.g. c("hp:mpg"="hp X mpg") for an interaction term.}

\item{gof_map}{data.frame with four columns: `raw`, `clean`, `fmt`, and
`omit`. If `gof_map` is NULL, then `modelsummary` will use this data frame
by default: `modelsummary::gof_map`}

\item{gof_omit}{string regular expression. Omits all matching gof statistics from
the table (using `grepl(perl=TRUE)`).}

\item{add_rows}{a data.frame (or tibble) with the same number of columns as
your main table. By default, rows are appended to the bottom of the table.
You can define a "position" attribute of integers to set the row positions.
See examples.}

\item{title}{string}

\item{notes}{list or vector of notes to append to the bottom of the table.}

\item{estimate}{character name of the estimate to display. Must be a column
name in the data.frame produced by `tidy(model)`. In the vast majority of
cases, the default value of this argument should not be changed.}

\item{...}{all other arguments are passed to the `tidy` and `glance` methods
used to extract estimates from the model. For example, this allows users to
set `exponentiate=TRUE` to exponentiate logistic regression coefficients.}
}
\value{
a regression table in a format determined by the `output` argument.
}
\description{
`modelsummary_wide` is a specialized function to display groups of
parameters from a single model in separate columns. This can be useful, for
example, to display the different levels of coefficients in a multinomial
regression model (e.g., `nnet::multinom`). The `coef_group` argument
specifies the name of the group identifier.
}
