% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_statistic_override.R
\name{extract_statistic_override}
\alias{extract_statistic_override}
\title{Allow users to override uncertainty estimates}
\usage{
extract_statistic_override(model, statistic_override, statistic = "std.error")
}
\arguments{
\item{model}{object type with an available `tidy` method.}

\item{statistic_override}{manually override the uncertainy estimates. This
argument accepts three types of input:
\itemize{
  \item a function or list of functions of length(models) which produce variance-covariance matrices with row and column names equal to the names of your coefficient estimates. For example, `R` supplies the `vcov` function, and the `sandwich` package supplies `vcovHC`, `vcovHAC`, etc.
  \item a list of length(models) variance-covariance matrices with row and column names equal to the names of your coefficient estimates.
  \item a list of length(models) vectors with names equal to the names of your coefficient estimates. Numeric vectors are formatted according to `fmt` and placed in brackets, character vectors printed as given.
}}

\item{statistic}{string name of the statistic to include in parentheses
below estimates. Must be either "conf.int", or one of the column names
produced by the `broom::tidy` function. Typical values include: "std.error",
"conf.int", "statistic", "p.value". A character vector will stack several
uncertainty estimates on top of one another (in different rows).}
}
\value{
a numeric vector of test statistics
}
\description{
Allow users to override uncertainty estimates
}
\keyword{internal}
