% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingmodelplots.R
\name{plot_response}
\alias{plot_response}
\title{Response plot}
\usage{
plot_response(
  data = plot_input,
  highlight_ntile = NA,
  highlight_how = "plot_text",
  save_fig = FALSE,
  save_fig_filename = NA,
  custom_line_colors = NA,
  custom_plot_text = NULL
)
}
\arguments{
\item{data}{Dataframe. Dataframe needs to be created with \code{\link{plotting_scope}}
or else meet required input format.}

\item{highlight_ntile}{Integer. Specifying the ntile at which the plot is annotated
and/or performances are highlighted.}

\item{highlight_how}{String. How to annotate the plot. Possible values: "plot_text","plot", "text".
Default is "plot_text", both highlighting the ntile and value on the plot as well as in text below the plot.
"plot" only highligths the plot, but does not add text below the plot explaining the plot at chosen ntile.
"text" adds text below the plot explaining the plot at chosen ntile but does not highlight the plot.}

\item{save_fig}{Logical. Save plot to file? Default = FALSE. When set to TRUE, saved plots are optimized for 18x12cm.}

\item{save_fig_filename}{String. Filename of saved plot. Default the plot is saved as {tempdir()}/{plotname}.png.}

\item{custom_line_colors}{Vector of Strings. Specifying colors for the lines in the plot.
When not specified, colors from the RColorBrewer palet "Set1" are used.}

\item{custom_plot_text}{List. List with customized textual elements for plot. Create a list with defaults
by using \code{\link{customize_plot_text}} and override default values to customize.}
}
\value{
ggplot object. Response plot.
}
\description{
Generates the response plot. It plots the percentage of target class observations
per ntile. It can be used to answer the following business question: When we apply
the model and select ntile X, what is the expected percentage of target class observations
in that ntile?
}
\examples{
# load example data (Bank clients with/without a term deposit - see ?bank_td for details)
data("bank_td")
# prepare data for training model for binomial target has_td and train models
train_index =  sample(seq(1, nrow(bank_td)),size = 0.5*nrow(bank_td) ,replace = FALSE)
train = bank_td[train_index,c('has_td','duration','campaign','pdays','previous','euribor3m')]
test = bank_td[-train_index,c('has_td','duration','campaign','pdays','previous','euribor3m')]
#train models using caret... (or use mlr or H2o or keras ... see ?prepare_scores_and_ntiles)
# setting caret cross validation, here tuned for speed (not accuracy!)
fitControl <- caret::trainControl(method = "cv",number = 2,classProbs=TRUE)
# random forest using ranger package, here tuned for speed (not accuracy!)
rf = caret::train(has_td ~.,data = train, method = "ranger",trControl = fitControl,
                  tuneGrid = expand.grid(.mtry = 2,.splitrule = "gini",.min.node.size=10))
# mnl model using glmnet package
mnl = caret::train(has_td ~.,data = train, method = "glmnet",trControl = fitControl)
# load modelplotr
library(modelplotr)
# transform datasets and model objects to input for modelplotr
scores_and_ntiles <- prepare_scores_and_ntiles(datasets=list("train","test"),
                         dataset_labels = list("train data","test data"),
                         models = list("rf","mnl"),
                         model_labels = list("random forest","multinomial logit"),
                         target_column="has_td",
                         ntiles=100)
plot_input <- plotting_scope(prepared_input = scores_and_ntiles)
plot_response(data=plot_input)
plot_response(data=plot_input,custom_line_colors=RColorBrewer::brewer.pal(3,"Dark2"))
plot_response(data=plot_input,highlight_ntile=2)
}
\seealso{
\code{\link{modelplotr}} for generic info on the package \code{moddelplotr}

\code{vignette('modelplotr')}

\code{\link{plotting_scope}} for details on the function \code{plotting_scope} that
transforms a dataframe created with  \code{prepare_scores_and_ntiles} or \code{aggregate_over_ntiles} to
a dataframe in the required format for all modelplotr plots.

\code{\link{aggregate_over_ntiles}} for details on the function \code{aggregate_over_ntiles} that
aggregates the output of \code{prepare_scores_and_ntiles} to create a dataframe with aggregated actuals and predictions.
In most cases, you do not need to use it since the \code{plotting_scope} function will call this function automatically.

\url{https://github.com/modelplot/modelplotr} for details on the package

\url{https://modelplot.github.io/} for our blog on the value of the model plots
}
