% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametersmodelplots.R
\name{customize_plot_text}
\alias{customize_plot_text}
\title{Customize textual elements of the plots}
\usage{
customize_plot_text(plot_input = plot_input)
}
\arguments{
\item{plot_input}{Dataframe. Dataframe needs to be created with
\code{\link{plotting_scope}} or else meet required input format.}
}
\value{
List with default values for all textual elements of the plots.
}
\description{
Function to overrule the default textual elements in the plots, like title, subtitle,
axis labels and annotation texts when the highlighting parameter \code{highlight_ntile}
is specified.
}
\section{How to customize textual elements of plots}{

All textual parts of the plots can be customized, for instance to translate
textual elements to another language or to change the annotation text that is added with the
\code{highlight_ntile} parameter. Once you have created the \code{plot_input} dataframe
using \code{plotting_Scope}, you can run this \code{customize_plot_text()} function.
It returns a list, containing all textual elements of the plots, including annotation texts.
For instance, run \cr\cr
\code{my_plot_text <- customize_plot_text(plot_input = plot_input)} \cr\cr
The list contains plot-specific elements (e.g. \code{...$cumgains$...})). \cr
Now, you can change the textual elements by overriding the element(s) you want to customize.
For instance, if you want to change the textual elements of the gains plot to Dutch:\cr\cr
\code{my_plot_text$gains$plottitle <- 'Cumulatieve Gains grafiek'}\cr
\code{my_plot_text$gains$x_axis_label <- 'Deciel'}\cr
\code{my_plot_text$gains$y_axis_label <- 'cumulatieve gains'}\cr
\code{my_plot_text$cumgains$optimal_gains_label <- 'maximale gains'}\cr
\code{my_plot_text$cumgains$minimal_gains_label <- 'minimale gains'}\cr
\code{plot_cumgains(custom_plot_text = my_plot_text)}\cr\cr
To change the annotation text, use the placeholders starting with '&' to dynamically include:
\tabular{ll}{
  \bold{palaceholder} \tab \bold{placeholder value}\cr
  \code{&NTL} \tab ntile specified with parameter \code{highlight_ntile}.\cr
  \code{&PCTNTL} \tab Total percentage of dataset selected up until specified ntile.\cr
  \code{&MDL} \tab Selected model label(s).\cr
  \code{&DS} \tab Selected dataset label(s).\cr
  \code{&YVAL} \tab Selected target class (Y-value).\cr
  \code{&VALUE} \tab The plot specific value at specified ntile.
  Eg. Cumulative gains, Rumulative lift, Response, Cumulative response, Profit, ROI or Revenue.\cr
}
For instance, to translate the gains plot annotation text to Dutch:\cr
\code{my_plot_text$cumlift$annotationtext <- "Door &PCTNTL met de hoogste modelkans volgens model &MDL
in &DS te selecteren is deze selectie van &YVAL observaties &CUMLIFT keer beter dan een random selectie."}\cr
\code{plot_cumlift(highlight_ntile=3,custom_plot_text=my_plot_text)}
}

\examples{
# load example data (Bank clients with/without a term deposit - see ?bank_td for details)
data("bank_td")

# prepare data for training model for binomial target has_td and train models
train_index =  sample(seq(1, nrow(bank_td)),size = 0.5*nrow(bank_td) ,replace = FALSE)
train = bank_td[train_index,c('has_td','duration','campaign','pdays','previous','euribor3m')]
test = bank_td[-train_index,c('has_td','duration','campaign','pdays','previous','euribor3m')]

#train models using caret... (or use mlr or H2o or keras ... see ?prepare_scores_and_ntiles)
# setting caret cross validation, here tuned for speed (not accuracy!)
fitControl <- caret::trainControl(method = "cv",number = 2,classProbs=TRUE)
# random forest using ranger package, here tuned for speed (not accuracy!)
rf = caret::train(has_td ~.,data = train, method = "ranger",trControl = fitControl,
                  tuneGrid = expand.grid(.mtry = 2,.splitrule = "gini",.min.node.size=10))
# mnl model using glmnet package
mnl = caret::train(has_td ~.,data = train, method = "glmnet",trControl = fitControl)

# load modelplotr
library(modelplotr)

# transform datasets and model objects to input for modelplotr
scores_and_ntiles <- prepare_scores_and_ntiles(datasets=list("train","test"),
                         dataset_labels = list("train data","test data"),
                         models = list("rf","mnl"),
                         model_labels = list("random forest","multinomial logit"),
                         target_column="has_td",
                         ntiles=100)

# set scope for analysis (default: no comparison)
plot_input <- plotting_scope(prepared_input = scores_and_ntiles)

# customize all textual elements of plots
mytexts <- customize_plot_text(plot_input = plot_input)
mytexts$cumresponse$plottitle <- 'Expected conversion rate for Campaign XYZ'
mytexts$cumresponse$plotsubtitle <- 'proposed selection: best 15 percentiles according to our model'
mytexts$cumresponse$y_axis_label <- '\% Conversion'
mytexts$cumresponse$x_axis_label <- 'percentiles (percentile = 1\% of customers)'
mytexts$cumresponse$annotationtext <-
  "Selecting up until the &NTL percentile with model &MDL has an expected conversion rate of &VALUE"
plot_cumresponse(data=plot_input,custom_plot_text = mytexts,highlight_ntile = 15)
}
\seealso{
\code{\link{modelplotr}} for generic info on the package \code{moddelplotr}

\code{vignette('modelplotr')}

\url{https://github.com/modelplot/modelplotr} for details on the package

\url{https://modelplot.github.io/} for our blog on the value of the model plots
}
