% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{module.lm}
\alias{module.lm}
\title{R6 class representing a linear model.}
\description{
R6 class representing a linear model.

R6 class representing a linear model.
}
\examples{

## ------------------------------------------------
## Method `module.lm$op`
## ------------------------------------------------

\donttest{
modello.init()
X = number(as.matrix(rnorm(10)), dx=FALSE)
mdl = module.lm$new(1, 1, 1, b=FALSE)
print(X$v)
Yh = mdl$op(X)
print(Yh)
print(Yh$v)
modello.close()
}

## ------------------------------------------------
## Method `module.lm$obj`
## ------------------------------------------------

\donttest{
modello.init()
X = number(as.matrix(rnorm(10)), dx=FALSE)
y = number(as.matrix(rnorm(10)), dx=FALSE)
mdl = module.lm$new(1, 1, 1, b=FALSE)
g = graph.open()
J = mdl$obj(y, X)
graph.close()
J$dv = 1
g$bw()
print(lapply(mdl$pars(), function(x)x$dv))
modello.close()
}

## ------------------------------------------------
## Method `module.lm$pars`
## ------------------------------------------------

\donttest{
modello.init()
mdl = module.lm$new(1, 1, 1, b=FALSE)
print(mdl$pars())
print(lapply(mdl$pars(), function(x)x$v))
print(lapply(mdl$pars(), function(x)x$dv))
modello.close()
}
}
\author{
Filippo Monari
}
\section{Super class}{
\code{\link[modello:module]{modello::module}} -> \code{module.lm}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{module.lm$new()}}
\item \href{#method-op}{\code{module.lm$op()}}
\item \href{#method-obj}{\code{module.lm$obj()}}
\item \href{#method-pars}{\code{module.lm$pars()}}
\item \href{#method-clone}{\code{module.lm$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="module" data-id="j">}\href{../../modello/html/module.html#method-j}{\code{modello::module$j()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="module" data-id="name">}\href{../../modello/html/module.html#method-name}{\code{modello::module$name()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="module" data-id="npars">}\href{../../modello/html/module.html#method-npars}{\code{modello::module$npars()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="module" data-id="save">}\href{../../modello/html/module.html#method-save}{\code{modello::module$save()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="module" data-id="y">}\href{../../modello/html/module.html#method-y}{\code{modello::module$y()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
The initialisation method sets the weights (W), the bais (B) matrices,
the objective function (obj), as well as the name of the module.
The calculation performed is the following
ans = W.op(X) + B
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module.lm$new(tx, nin, nout, obj = mse, b = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tx}}{if TRUE it traspose the input matrix}

\item{\code{nin}}{number of column of the input matrix}

\item{\code{nout}}{number of outputs}

\item{\code{obj}}{objective function to adopt}

\item{\code{b}}{if TRUE the intercept term is included}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns the total number of parameters
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-op"></a>}}
\if{latex}{\out{\hypertarget{method-op}{}}}
\subsection{Method \code{op()}}{
Performs: ans = W.op(X) + B
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module.lm$op(X)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{input matrix, reference object of class 'number'}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a reference object of class 'number'
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init()
X = number(as.matrix(rnorm(10)), dx=FALSE)
mdl = module.lm$new(1, 1, 1, b=FALSE)
print(X$v)
Yh = mdl$op(X)
print(Yh)
print(Yh$v)
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-obj"></a>}}
\if{latex}{\out{\hypertarget{method-obj}{}}}
\subsection{Method \code{obj()}}{
Calculates the objective function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module.lm$obj(y, X)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{y}}{target values, reference object of class 'number'}

\item{\code{X}}{input matrix, reference object of class 'number'}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a reference object of class 'number'
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init()
X = number(as.matrix(rnorm(10)), dx=FALSE)
y = number(as.matrix(rnorm(10)), dx=FALSE)
mdl = module.lm$new(1, 1, 1, b=FALSE)
g = graph.open()
J = mdl$obj(y, X)
graph.close()
J$dv = 1
g$bw()
print(lapply(mdl$pars(), function(x)x$dv))
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pars"></a>}}
\if{latex}{\out{\hypertarget{method-pars}{}}}
\subsection{Method \code{pars()}}{
Returns the parameters of the module as list with entries:
W = weight matrix, and B = bias matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module.lm$pars()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns a flat list with the parametrs of the module
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
modello.init()
mdl = module.lm$new(1, 1, 1, b=FALSE)
print(mdl$pars())
print(lapply(mdl$pars(), function(x)x$v))
print(lapply(mdl$pars(), function(x)x$dv))
modello.close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module.lm$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
