% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{module.LstmUnit}
\alias{module.LstmUnit}
\title{R6 class representing the recurrent layer of a
LSTM network}
\description{
R6 class representing the recurrent layer of a
LSTM network

R6 class representing the recurrent layer of a
LSTM network
}
\author{
Filippo Monari
}
\section{Super class}{
\code{\link[modello:module]{modello::module}} -> \code{module.LstmUnit}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{module.LstmUnit$new()}}
\item \href{#method-op}{\code{module.LstmUnit$op()}}
\item \href{#method-pars}{\code{module.LstmUnit$pars()}}
\item \href{#method-clone}{\code{module.LstmUnit$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="module" data-id="j">}\href{../../modello/html/module.html#method-j}{\code{modello::module$j()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="module" data-id="name">}\href{../../modello/html/module.html#method-name}{\code{modello::module$name()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="module" data-id="npars">}\href{../../modello/html/module.html#method-npars}{\code{modello::module$npars()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="module" data-id="obj">}\href{../../modello/html/module.html#method-obj}{\code{modello::module$obj()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="module" data-id="save">}\href{../../modello/html/module.html#method-save}{\code{modello::module$save()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="module" data-id="y">}\href{../../modello/html/module.html#method-y}{\code{modello::module$y()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialisation method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module.LstmUnit$new(tx, nh, nx, act)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tx}}{transposition flag. If > 0 op(x) = t(x)}

\item{\code{nh}}{number of input from the previous time steps}

\item{\code{nx}}{number of input form the current time step}

\item{\code{act}}{activation function}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-op"></a>}}
\if{latex}{\out{\hypertarget{method-op}{}}}
\subsection{Method \code{op()}}{
Performs:
input_gate = Wxi . op(x) + Whi . h + Bi
forget_gate = Wxf . op(x) + Whf . h + Bf
output_gate = Wxo . op(x) + Who . h + Bo
current_cell = act(Wxg . op(x) + Whg . h + Bg)
cell_sate = forget_gate * cell_previous + input_gate * cell_current
hidden_state = output_gate * act(cell_state)
Returns a list composed by hidde_state and cell_state
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module.LstmUnit$op(h, g, x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{h}}{past hidden state}

\item{\code{g}}{past cell state}

\item{\code{x}}{current input}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pars"></a>}}
\if{latex}{\out{\hypertarget{method-pars}{}}}
\subsection{Method \code{pars()}}{
Returns a list with the model parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module.LstmUnit$pars()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module.LstmUnit$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
