% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numbers_math.R
\name{ldlaplace.modello_number}
\alias{ldlaplace.modello_number}
\alias{ldlaplace}
\title{Laplace Distribution: log-density}
\usage{
\method{ldlaplace}{modello_number}(y, mu, lam)

ldlaplace(y, mu, lam)
}
\arguments{
\item{y}{observations, numeric or reference object of class 'number'}

\item{mu}{location parameter, numeric or reference object of class 'number'}

\item{lam}{rate parameter, numeric of reference object of class 'number'}
}
\value{
Returns a 'numeric' or a reference object of class 'number'
}
\description{
Considering a Laplace Distribution
calculates the log-density
\deqn{ld = log(0.5) + log(\lambda) - \lambda * |y - \mu|}
}
\examples{
modello.init(10, 10, 10, 10)
y = number(rnorm(10))
ld = ldlaplace(y, .k(0), .k(1))
print(ld)
print(ld$v)
modello.close()
}
\author{
Filippo Monari
}
