% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_called.R
\name{expect_called}
\alias{expect_called}
\title{Add expectation to a function.}
\usage{
expect_called(func, to_mock, expected_call_list)
}
\arguments{
\item{func}{The function you plan to call, and within which you want
to verify a call to another function.}

\item{to_mock}{A string that is the name of the function you want to
verify a call to.}

\item{expected_call_list}{This is the list of parameters you expect
to be present in the function call. It can be a list with or
without names. If it is a list with names, it can be a partial
list, i.e. it doesn't need to include all the parameters. Only
the included parameters will be checked.}
}
\description{
Works with named or unnamed call list. If unnamed, must be
a complete call list, if named can be partial.
}
\examples{
# given                                                                     
g <- function(y, z, x) y + z + x + 10                                        
f <- function(x) g(y=1, z=2, x=(x + 1))                                      

# expect                                                                    
expect_called(f, 'g', list(y=1, x=6))                              

# when                                                                      
f(5)   

}

