% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mobr.R
\name{make_mob_in}
\alias{make_mob_in}
\title{Create the 'mob_in' object.}
\usage{
make_mob_in(
  comm,
  plot_attr,
  coord_names = NULL,
  binary = FALSE,
  latlong = FALSE
)
}
\arguments{
\item{comm}{community matrix in which rows are samples (e.g., plots) and
columns are species.}

\item{plot_attr}{matrix which includes the environmental attributes and
spatial coordinates of the plots. Environmental attributes are mandatory,
while spatial coordinates are optional.}

\item{coord_names}{character vector with the names of the columns of
\code{plot_attr} that specify the coordinates of the samples. Defaults to
NULL (no coordinates). When providing coordinate names, the order the names
are provided matters when working with latitude-longitude coordinates
(i.e., argument \code{latlong = TRUE}, and it is expected that the column
specifying the x-coordinate or the longitude is provided first, y-coordinate
 or latitude provided second. To provide coordinate names use the following
 syntax: \code{coord_names = c('longitude_col_name','latitude_col_name')}}

\item{binary}{Boolean, defaults to FALSE. Whether the plot by species matrix
"comm" is in abundances or presence/absence.}

\item{latlong}{Boolean, defaults to FALSE. Whether the coordinates are
latitude-longitudes. If TRUE, distance calculations by downstream functions
are based upon great circle distances rather than Euclidean distances. Note
latitude-longitudes should be in decimal degree.}
}
\value{
a "mob_in" object with four attributes. "comm" is the plot by species
  matrix. "env" is the environmental attribute matrix, without the spatial
  coordinates. "spat" contains the spatial coordinates (1-D or 2-D). "tests"
  specifies whether each of the three tests in the biodiversity analyses is
  allowed by data.
}
\description{
The 'mob_in' object will be passed on for analyses of biodiversity across
scales.
}
\examples{
 data(inv_comm)
 data(inv_plot_attr)
 inv_mob_in = make_mob_in(inv_comm, inv_plot_attr, coord_names = c('x', 'y'))
}
\author{
Dan McGlinn and Xiao Xiao
}
