% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.mf.object.glm.R
\name{get.mf.object.glm}
\alias{get.mf.object.glm}
\title{Fit a general linear model to a mobForest model}
\usage{
get.mf.object.glm(object, main_model, partition_vars, data, new_test_data,
  ntree, family, prob_cutoff = 0.5)
}
\arguments{
\item{object}{A bootstrap model object created by
\link[=bootstrap]{bootstrap()}}

\item{main_model}{A model in character format.}

\item{partition_vars}{A vector of partition variables.}

\item{data}{A data frame containing the variables in the model.}

\item{new_test_data}{A data frame representing test data for validating
random forest model. This data is not used in the tree building process}

\item{ntree}{Number of trees to be constructed in forest (default = 300).}

\item{family}{A description of error distribution and link function to be
used in the model. This parameter needs to be specified if generalized
linear model is considered. The parameter "binomial()" is to be specified
when logistic regression is considered and "poisson()" when Poisson
regression is considered as the node model. The values allowed for this
parameter are binomial() and poisson().}

\item{prob_cutoff}{In case of logistic regression as a node model, the
predicted probabilities for OOB cases are converted into classes (yes/no,
high/low, etc as specified) based on this probability cutoff. If logistic
regression is not considered as node model, the prob_cutoff = NULL. By
default it is 0.5 when parameter not specified (and logistic regression
considered).}
}
\value{
An object of class \code{\linkS4class{mobforest.output}}.
}
\description{
This method computes predicted outcome for each observation in the data
frame using the tree model supplied as an input argument.
}
\seealso{
\link[=mobforest.control]{mobforest.control()},
\code{\link{mobforest.output-class}}
}
