% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varimp.plot.R
\name{varimplot}
\alias{varimplot}
\title{A plot with variable importance score on X-axis and variable name on
Y-axis.}
\usage{
varimplot(object)
}
\arguments{
\item{object}{An object of class \code{\linkS4class{mobforest.output}}
returned by \link[=mobforest.analysis]{mobforest.analysis()}}
}
\description{
A plot with variable importance score on X-axis and variable name on
Y-axis.
}
\examples{
\dontrun{
library(mlbench)
set.seed(1111)
# Random Forest analysis of model based recursive partitioning load data
data("BostonHousing", package = "mlbench")
BostonHousing <- BostonHousing[1:90, c("rad", "tax", "crim", "medv", "lstat")]

# Recursive partitioning based on linear regression model medv ~ lstat with 3
# trees.  1 core/processor used. 
rfout <- mobforest.analysis(as.formula(medv ~ lstat), c("rad", "tax", "crim"),
    mobforest_controls = mobforest.control(ntree = 3, mtry = 2, replace = T,
        alpha = 0.05, bonferroni = T, minsplit = 25), data = BostonHousing,
    processors = 1, model = linearModel, seed = 1111)
 varimplot(rfout)
}

}
\references{
Leo Breiman (2001). Random Forests. \emph{Machine Learning},
45(1), 5-32.\cr
}
\seealso{
\link[=get.varimp]{get.varimp}
}
