% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomEffects.R
\name{rRxNorm}
\alias{rRxNorm}
\title{Conditional sampling for Multivariate-Normal Random-Effects model.}
\usage{
rRxNorm(n, x, V, lambda, Sigma)
}
\arguments{
\item{n}{Integer number of random samples to generate.}

\item{x}{Data observations.  Either a vector of length \code{q} or a \code{n x q} matrix.  In the latter case each row is a different vector.}

\item{V}{Observation variances.  Either a matrix of size \code{q x q} or a \code{q x q x n} array.}

\item{lambda}{Prior means.  Either a vector of length \code{q} or an \code{n x q} matrix.  In the latter case each row is a different mean.  Defaults to zeros.}

\item{Sigma}{Prior variances.  Either a matrix of size \code{q x q} or a \code{q x q x n} array.  Defaults to identity matrix.}
}
\description{
Sample from the conditional parameter distribution given the data and hyperparameters of the Multivariate-Normal Random-Effects (mNormRE) model (see \strong{Details}).
}
\details{
Consider the hierarchical multivariate normal model
\deqn{
\arraycolsep=1.4pt
\begin{array}{rcl}
\boldsymbol{\mu} & \sim & \mathcal{N}(\boldsymbol{\lambda}, \boldsymbol{\Sigma}) \\
\boldsymbol{x} \mid \boldsymbol{\mu} & \sim & \mathcal{N}(\boldsymbol{\mu}, \boldsymbol{V}).
\end{array}
}{
\mu ~ N(\lambda, \Sigma)
}
\deqn{
\vspace{-2em}
}{
x | \mu ~ N(\mu, V).
}
The Multivariate-Normal Random-Effects model \eqn{\boldsymbol{\mu} \sim \textrm{RxNorm}(\boldsymbol{x}, \boldsymbol{V}, \boldsymbol{\lambda}, \boldsymbol{\Sigma})}{\mu ~ RxNorm(x, V, \lambda, \Sigma)} on the random vector \eqn{\boldsymbol{\mu}_q}{\mu_q} is defined as the posterior distribution \eqn{p(\boldsymbol{\mu} \mid \boldsymbol{x}, \boldsymbol{\lambda}, \boldsymbol{\Sigma})}{p(\mu | x, \lambda, \Sigma)}.  This distribution is multivariate normal; for the mathematical specification of its parameters please see \code{vignette("mniw-distributions", package = "mniw")}.
}
\examples{
# data specification
q <- 5
y <- rnorm(q)
V <- rwish(1, diag(q), q+1)
# prior specification
lambda <- rep(0,q)
A <- diag(q)
n <- 10
# random sampling
rRxNorm(n, y, V, lambda, A)
}
