% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{h_partial_fun_args}
\alias{h_partial_fun_args}
\title{Create Partial Functions}
\usage{
h_partial_fun_args(fun, ..., additional_attr = list())
}
\arguments{
\item{fun}{(\code{function})\cr to be wrapped.}

\item{...}{Additional arguments for \code{fun}.}

\item{additional_attr}{(\code{list})\cr of additional attributes to apply to the result.}
}
\value{
Object with S3 class \code{"partial"}, a \code{function} with \code{args} attribute (and possibly more
attributes from \code{additional_attr}).
}
\description{
Creates partial functions with arguments.
}
\details{
This function add \code{args} attribute to the original function,
and add an extra class \code{partial} to the function.
\code{args} is the argument for the function, and elements in \code{...} will override the existing
arguments in attribute \code{args}. \code{additional_attr} will override the existing attributes.
}
\keyword{internal}
