% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{h_anova_single_mmrm_model}
\alias{h_anova_single_mmrm_model}
\title{Calculate the Significance of Each Term in an \code{mmrm} Fit.}
\usage{
h_anova_single_mmrm_model(object)
}
\arguments{
\item{object}{(\code{mmrm})\cr an \code{mmrm} object.}
}
\value{
A data frame with a row for each term in \code{object}, including an
intercept if present. The \link{row.names} of the data frame identify the terms.
The data frame will contain the following four columns:
\itemize{
\item \code{num_df}: the numerator degrees of freedom.
\item \code{denom_df}: the denominator degrees of freedom.
\item \code{f_stat}: the test statistic on the F-distribution.
\item \code{p_va}: the associated p-value.
}
}
\description{
Runs \code{\link[=df_md]{df_md()}} once for each term in an \code{mmrm} object and returns the results
in a data frame.
}
\details{
When only one model fit is passed to \code{\link[=anova.mmrm]{anova.mmrm()}}, the \code{object} argument of
\code{anova.mmrm()} is passed directly to this function.
}
\keyword{internal}
