% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postgresModule.R
\name{postgresServer}
\alias{postgresServer}
\title{Server function for Postgres Shiny Module}
\usage{
postgresServer(id, dbname, datatable, host, port, user, password, data)
}
\arguments{
\item{id}{A character string that matches the ID used in \code{postgresUI()}}

\item{dbname}{A character string specifying the name of the database}

\item{datatable}{A character string specifying the name of the table in the database}

\item{host}{A character string specifying the host of the database}

\item{port}{A numeric value specifying the port number for the database connection}

\item{user}{A character string specifying the username for database access}

\item{password}{A character string specifying the password for database access}

\item{data}{A reactive expression that provides the data to be submitted}
}
\value{
A list of functions and reactive values:
\item{saveData}{A function to save data to the database}
\item{loadData}{A function to load data from the database}
\item{current_data}{A reactive value containing the current data in the table}
\item{data_to_submit}{A reactive value containing the data to be submitted}
}
\description{
This function sets up the server-side logic for the Postgres Shiny module,
handling database connections, data submission, retrieval, and download.
}
\examples{
server <- function(input, output, session) {
  postgres_module <- postgresServer("postgres_module", "my_db", "my_table",
                                    "localhost", 5432, "user", "password",
                                    reactive({ input$data }))
 }
}
