% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morph.R
\name{gaussianSmooth}
\alias{gaussianSmooth}
\title{Smooth a numeric array with a Gaussian kernel}
\usage{
gaussianSmooth(x, sigma)
}
\arguments{
\item{x}{An object that can be coerced to an array, or for which a
\code{\link{morph}} method exists.}

\item{sigma}{A numeric vector giving the standard deviation of the kernel in
each dimension. Can have lower dimensionality than the target array.}
}
\value{
A morphed array with the same dimensions as the original array.
}
\description{
This function smoothes an array using a Gaussian kernel with a specified
standard deviation.
}
\details{
This implementation takes advantage of the separability of the Gaussian
kernel for speed when working in multiple dimensions. It is therefore
equivalent to, but much faster than, directly applying a multidimensional
kernel.
}
\seealso{
\code{\link{morph}} for the function underlying this operation,
  \code{\link{gaussianKernel}} for generating Gaussian kernels (which is
  also used by this function), and \code{\link{erode}} for mathematical
  morphology functions.
}
\author{
Jon Clayden <code@clayden.org>
}
