% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlts_model.R
\name{mlts_model}
\alias{mlts_model}
\title{Build a multilevel latent time series model}
\usage{
mlts_model(
  class = c("VAR"),
  q,
  p = NULL,
  max_lag = c(1, 2, 3),
  btw_factor = TRUE,
  btw_model = NULL,
  fix_dynamics = FALSE,
  fix_inno_vars = FALSE,
  fix_inno_covs = TRUE,
  inno_covs_zero = FALSE,
  inno_covs_dir = NULL,
  fixef_zero = NULL,
  ranef_zero = NULL,
  ranef_pred = NULL,
  out_pred = NULL,
  out_pred_add_btw = NULL
)
}
\arguments{
\item{class}{Character. Indicating the model type to be specified. For now
restricted to \code{VAR}, the default. Future package releases might include additional
model types.}

\item{q}{Integer. The number of time-varying constructs.}

\item{p}{Integer. For multiple-indicator models, specify a vector of length
\code{q} with the number of manifest indicators per construct. If all constructs are
measured with the same number of indicators, a single value is sufficient.}

\item{max_lag}{Integer. The maximum lag of the autoregressive effect to be
included in the model. The maximum is 3. Defaults to 1.}

\item{btw_factor}{Logical. If \code{TRUE} (the default), a common between-level factor
is modeled across all indicator variables per construct \code{q}. If \code{FALSE}, instead of a between-level
factor, indicator mean levels will be included as individual (random) effects drawn
from a joint multivariate normal distribution.}

\item{btw_model}{A list to indicate for which manifest indicator variables a common
between-level factor should be modeled (see Details for detailed instructions).
At this point restricted to one factor per latent construct.}

\item{fix_dynamics}{Logical. Fix all random effect variances of autoregressive and
cross-lagged effects to zero (constraining parameters to be equal across clusters).}

\item{fix_inno_vars}{Logical. Fix all random effect variances of innovation variances
to zero (constraining parameters to be equal across clusters).}

\item{fix_inno_covs}{Logical. Fix all random effect variances of innovation covariances
to zero (constraining parameters to be equal across clusters).}

\item{inno_covs_zero}{Logical. Set to \code{TRUE} to treat all innovations as independent.}

\item{inno_covs_dir}{For bivariate VAR models with person-specific innovation covariances,
a latent variable approach is applied (for a detailed description, see Hamaker et al., 2018).
by specifying an additional factor that loads onto the contemporaneous innovations of both constructs,
capturing the shared variance of innovations, that is not predicted by the previous time points.
The loading parameters of this latent factor, however, have to be restricted in accordance with
researchers assumptions about the sign of the association between innovations across construct.
Hence, if innovations at time $t$ are assumed to be positively correlated across clusters, set the
argument to \code{pos}, or \code{neg} respectively.}

\item{fixef_zero}{Character. A character vector to index which fixed effects
(referring to the parameter labels in \code{model$Param}) should be constrained to zero
(Note: this also results in removing the random effect variance of the respective parameter).}

\item{ranef_zero}{Character. A character vector to index which random effect variances
(referring to the parameter labels in \code{model$Param}) should be constrained to zero.}

\item{ranef_pred}{A character vector or a named list. Include between-level covariate(s)
as predictor(s) of all random effects in \code{model} by entering a vector of unique variable
names. Alternatively, to include between-level covariates or differing sets of
between-level covariates as predictors of specific random effects, a named
list (using the labels in \code{model$Param}) can be entered (see examples).
Note that if a named list is provided, all names that do not match random
parameters in \code{model} will be ignored. Note that variables entered in \code{ranef_pred} will
be grand-mean centered by default when fitting the model with \code{mlts_fit}.}

\item{out_pred}{A character vector or a named list. Include between-level outcome(s)
to be regressed on all random effects in \code{model} by entering a vector of unique variable
names. Alternatively, to include multiple between-level outcomes regressed differing sets of
specific random effects, a named list (using the labels in \code{model$Param}) can be entered
(see examples). Note that if a named list is provided, all character strings in the vector of each list
(with independent variables) element that do not match random effect parameter names
in \code{model$Param} will be treated as additional between-level predictors.}

\item{out_pred_add_btw}{A character vector. If \code{out_pred} is a character (vector), all
inputs will be treated as between-level covariates to be used as additional predictors of
all outcomes specified in \code{out_pred}.}
}
\value{
An object of class \code{data.frame} with the following columns:
\item{Model}{Indicates if the parameter in the respective row is part of the structural, or
the measurement model (if multiple indicators per construct are provided)}
\item{Level}{Parameter on the between- or within-level.}
\item{Type}{Describes the parameter type.}
\item{Param}{Parameter names to be referred to in arguments of \code{mlts_model}.}
\item{Param_Label}{Parameter labels (additional option to address specific parameters).}
\item{isRandom}{Indicates which within-level parameters are modeled as random (1) or a constant
across clusters (0).}
\item{Constraint}{Optional. Included if multiple-indicators per construct (p > 1) are provided.
Constraints on measurement model parameters can be changed by overwriting the respective value
in \code{model}. Possible inputs are "free", "= 0" (for SDs of measurement error variances),
and "= 1" (for loading parameters).}
\item{prior_type}{Contains the parameters' prior distribution used in \code{mlts_fit} (prior classes
can not be changed at this point).}
\item{prior_location}{Location values of the parameters' prior distribution used
in \code{mlts_fit} (can be changed to any real value by overwriting the respective value in \code{model}).}
\item{prior_scale}{Scale values of the parameters' prior distribution used
in \code{mlts_fit} (can be changed to any real value by overwriting the respective value in \code{model}).}
}
\description{
Build a multilevel latent time series model
}
\examples{
\donttest{
 # To illustrate the general model building procedure, starting with a simple
 # two-level AR(1) model with person-specific individual means, AR effects,
 # and innovation variances (the default option when using mlts_model() and q = 1).
 model <- mlts_model(q = 1)

 # All model parameters (with their labels stored in model$Param) can be inspected by calling:
 model

 # Possible model extensions/restrictions:
 # 1. Introducing additional parameter constraints, such as fixing specific
 #    parameters to a constant value by setting the respective random effect
 #    variances to zero, such as e.g. (log) innovation variances
 model <- mlts_model(q = 1, ranef_zero = "ln.sigma2_1")
 #    Note that setting the argument `fix_inno_vars` to `TRUE` provides
 #    a shortcut to fixing the innovation variances of all constructs
 #    (if q >= 1) to a constant.

 # 2. Including a multiple indicator model, where the construct is measured by
 #    multiple indicators (here, p = 3 indicators)
 model <- mlts_model(
          q = 1, # the number of time-varying constructs
          p = 3, # the number of manifest indicators
          # assuming a common between-level factor (the default)
          btw_factor = TRUE
        )

 # 3. Incorporating between-level variables. For example, inclusion of
 #    an additional between-level variable ("cov1") as predictor of all
 #    (ranef_pred = "cov1") or a specific set of random effects
 #    (ranef_pred = list("phi(1)_11") = "cov1"), an external outcome (e.g., "out1")
 #    to be predicted by all (out_pred = "out1") or specific random effects
 #    (out_pred = list("out1" = c("etaB_1", "phi(1)_11")), using the latent
 #    between-level factor trait scores (etaB_1) and individual first-order
 #    autoregressive effects (phi(1)_11) as joint predictors of outcome "out1".
 model <- mlts_model(
            q = 1,
            p = 3,
            fix_inno_vars = TRUE,
            ranef_pred = "cov1",
            out_pred = list("out1" = c("etaB_1", "phi(1)_11"))
           )
 #    Note that the names of the random effect parameters must match the
 #    parameter labels provided in model$Param, the result of the
 #    mlts_model()-functions.

}
}
\references{
Hamaker, E. L., Asparouhov, T., Brose, A., Schmiedek, F., & Muthén, B. (2018).
At the frontiers of modeling intensive longitudinal data: Dynamic structural equation models
for the affective measurements from the COGITO study. \emph{Multivariate behavioral research}, \emph{53}(6), 820-841.
\doi{10.1080/00273171.2018.1446819}
}
