% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Test_statistics.R
\name{heter_gradient}
\alias{heter_gradient}
\title{Structural stability tests for non-stationary time series regression}
\usage{
heter_gradient(data, param, mvselect = -1, verbose_dist = FALSE, hyper = FALSE)
}
\arguments{
\item{data}{a list with the vector y (response) and the matrix x (covariates), for example, list(x=...,y=...).}

\item{param}{a list of parameters, list(B =..., lrvmethod =...,gcv = ..., neighbour =..., lb = ..., ub = ..., tau_n = ..., type = ..., ind = ...)}

\item{mvselect}{the value of moving window parameter \mjseqn{m}. In addition, mvselect=-1 provides data-driven smoothing parameters via Minimum Volatility of the long-run covariance estimator, while mvselect = -2 provides data-driven smoothing parameters via Minimum Volatility of the bootstrap statistics.}

\item{verbose_dist}{whether to print intermediate results, i.e., the bootstrap distribution and statistics, default FALSE.}

\item{hyper}{whether to only print the selected values of the smoothing parameters,\mjseqn{m} and \mjseqn{\tau_n}, default FALSE.}
}
\value{
p-value of the structural stability test
}
\description{
\loadmathjax Test for long memory of \mjseqn{e_i} in the time series regression \mjsdeqn{y_i = x_i \beta_i + e_i, 1\leq i \leq n} where \mjseqn{x_i} is the multivariate covariate process with first component 1, \mjseqn{\beta_i} is the coefficient, \mjseqn{e_i} is the error term which can be long memory. The goal is to test whether the null hypothesis  \mjsdeqn{\beta_1 = \ldots = \beta_n = \beta} holds. The alternative hypothesis is that the coefficient function \mjseqn{\beta_i} is time-varying.  Covariates and the error term are allowed to be dependent.
}
\details{
param
\itemize{
\item B, the number of bootstrap simulation, say 2000
\item lrvmethod  the method of long-run variance estimation, lrvmethod = -1 uses the ols plug-in estimator as in Wu and Zhou (2018), lrvmethod = 0 uses the plug-in estimator in Zhou (2010), lrvmethod = 1 offers the debias difference-based estimator in Bai and Wu (2023), lrvmethod = 2 provides the plug-in estimator using the \mjseqn{\breve{\beta}}, the pilot estimator proposed in Bai and Wu (2023)
\item gcv,  1 or 0, whether to use Generalized Cross Validation for the selection of \mjseqn{b}, the bandwidth parameter in the local linear regression, which will not be used when lrvmethod is -1, 1 or 2.
\item neighbour, the number of neighbours in the extended minimum volatility, for example 1,2 or 3
\item lb, the lower bound of the range of \mjseqn{m} in the extended minimum volatility Selection
\item ub,  the upper bound of the range of \mjseqn{m} in the extended minimum volatility Selection
\item bw_set, the proposed grid of the range of bandwidth selection, which is only useful when lrvmethod = 1. if not presented, a rule of thumb method will be used for the data-driven range.
\item tau_n,  the value of \mjseqn{\tau} when no data-driven selection is used. if \mjseqn{tau} is set to \mjseqn{0}, the rule of thumb \mjseqn{n^{-1/5}} will be used
\item type, default 0, uses the residual-based statistic proposed in Wu and Zhou (2018). ``type'' can also be set to -1, using the coefficient-based statistic in Wu and Zhou (2018).
\item ind,  types of kernels
\item 1 Triangular \mjseqn{1-|u|}, \mjseqn{u \le 1}
\item 2 Epanechnikov kernel \mjseqn{3/4(1 - u^{2})}, \mjseqn{u \le 1}
\item 3 Quartic \mjseqn{15/16(1 - u^{2})^{2}}, \mjseqn{u \le 1}
\item 4 Triweight \mjseqn{35/32(1 - u^{2})^{3}}, \mjseqn{u \le 1}
\item 5 Tricube  \mjseqn{70/81(1 - |u|^{3})^{3}}, \mjseqn{u \le 1}
}
}
\examples{
# choose a small B for tests
param = list(B = 50, bw_set = c(0.15, 0.25), gcv =1, neighbour = 1, lb = 10, ub = 20, type = 0)
n = 300
data = bregress2(n, 2, 1) # time series regression model with 2 changes points
param$lrvmethod = 0 # plug-in
heter_gradient(data, param, 4, 1)
param$lrvmethod = 1 # difference based
heter_gradient(data, param, 4, 1)
}
\references{
Bai, L., and Wu, W. (2023). Difference-based covariance matrix estimate in time series nonparametric regression with applications to specification tests.

Wu, W., and Zhou, Z. (2018). Gradient-based structural change detection for nonstationary time series M-estimation. The Annals of Statistics, 46(3), 1197-1224.

Politis, D. N., Romano, J. P., and Wolf, M. (1999). Subsampling. Springer Science & Business Media.
}
