% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setMBOControlMultiPoint.R
\name{setMBOControlMultiPoint}
\alias{setMBOControlMultiPoint}
\title{Set multipoint proposal options.}
\usage{
setMBOControlMultiPoint(control, method = NULL, cl.lie = NULL,
  moimbo.objective = NULL, moimbo.dist = NULL, moimbo.selection = NULL,
  moimbo.maxit = NULL, moimbo.sbx.eta = NULL, moimbo.sbx.p = NULL,
  moimbo.pm.eta = NULL, moimbo.pm.p = NULL)
}
\arguments{
\item{control}{[\code{\link{MBOControl}}]\cr
Control object for mbo.}

\item{method}{[\code{character(1)}]\cr
Method used for proposal of multiple infill points, for parallel batch evaluation.
Possible values are:
\dQuote{cb}: Proposes points by optimizing the confidence bound \dQuote{cb} criterion,
\code{propose.points} times. Each lambda value for \dQuote{cb} is drawn randomly from an
exp(1)-distribution, so do not define \code{infill.opt.cb.lambda}.
The optimizer for each proposal is configured in the same way as for the single point case,
i. e., by specifying \code{infill.opt} and related stuff.
\dQuote{moimbo}: Proposes points by multi-objective infill criteria via evolutionary multi-objective optimization.
The EA is a (mu+1) type of algorithm and runs for \code{moimbo.maxit} generations.
The population size is set to \code{propose.points}.
The selection criterion is \code{moimbo.selection}.
If this method is selected the infill criterion in \code{setMBOInfillCrit} is ignored.
\dQuote{cl}: Proposes points by constant liar strategy.
Only meaningful if \code{infill.crit == "cb"}
In the first step the kriging model is fitted based on the real data and the best point is calculated
according to the regular EI-criterion.
Then, the function value of the best point is simply guessed by the worst seen function evaluation.
This lie is used to update the model in order to propose the subsequent point.
The procedure is applied until the number of best points achieves \code{propose.points}.
Default is \code{cb}.}

\item{cl.lie}{[\code{function}]\cr
Function used by constant liar method for lying. Default is \code{min}.}

\item{moimbo.objective}{[\code{character(1)}]\cr
Objectives which are optimized in multi-objective approach.
Possible values are: \dQuote{mean.dist}, \dQuote{ei.dist}, \dQuote{mean.se}, \dQuote{mean.se.dist}.
Default is \dQuote{ei.dist}.}

\item{moimbo.dist}{[\code{character(1)}]\cr
Distance function used in multi-objective EA.
Possible values are: \dQuote{nearest.neighbor}, \dQuote{nearest.better}.
Default is \dQuote{nearest.better}.}

\item{moimbo.selection}{[\code{character(1)}]\cr
Method used for selecting 1 element for removal from the population
in each iteration of the multi-objective EA.
Possible values are:
\dQuote{hypervolume}: Non-dominated sorting + hypervolume contribution.
\dQuote{crowdingdist}: Non-dominated sorting + crowding distance based ranking.
\dQuote{first}: Non-dominated sorting + first objective of \code{moimbo.objective} as criterion.
\dQuote{last}: Non-dominated sorting + last objective of \code{moimbo.objective} as criterion.
Default is \code{hypervolume}.}

\item{moimbo.maxit}{[\code{character(1)}]\cr
Number of generations for multi-objective EA.
Default is 100.}

\item{moimbo.sbx.eta}{[\code{numeric(1)}]\cr
Distance parameter of crossover distribution, see \code{\link[emoa]{sbx_operator}}.
Default is 15.}

\item{moimbo.sbx.p}{[\code{numeric(1)}]\cr
Probability of 1-point crossover, see \code{\link[emoa]{sbx_operator}}.
Default is 1.}

\item{moimbo.pm.eta}{[\code{numeric(1)}]\cr
Distance parameter of mutation distribution, see \code{\link[emoa]{pm_operator}}.
Default is 15.}

\item{moimbo.pm.p}{[\code{numeric(1)}]\cr
Probability of 1-point mutation, see \code{\link[emoa]{pm_operator}}.
Default is 1.}
}
\value{
[\code{\link{MBOControl}}].
}
\description{
Extends an MBO control object with options for multipoint proposal.
}
\seealso{
Other MBOControl: \code{\link{makeMBOControl}},
  \code{\link{setMBOControlInfill}},
  \code{\link{setMBOControlMultiObj}},
  \code{\link{setMBOControlTermination}}
}
