% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.ResamplingSptCVCluto}
\alias{autoplot.ResamplingSptCVCluto}
\alias{autoplot.ResamplingRepeatedSptCVCluto}
\alias{plot.ResamplingSptCVCluto}
\alias{plot.ResamplingRepeatedSptCVCluto}
\title{Visualization Functions for SptCV Cluto Methods.}
\usage{
\method{autoplot}{ResamplingSptCVCluto}(
  object,
  task,
  fold_id = NULL,
  plot_as_grid = TRUE,
  train_color = "#0072B5",
  test_color = "#E18727",
  tickformat_date = "\%Y-\%m",
  nticks_x = 3,
  nticks_y = 3,
  point_size = 3,
  axis_label_fontsize = 11,
  sample_fold_n = NULL,
  ...
)

\method{autoplot}{ResamplingRepeatedSptCVCluto}(
  object,
  task,
  fold_id = NULL,
  repeats_id = 1,
  plot_as_grid = TRUE,
  train_color = "#0072B5",
  test_color = "#E18727",
  sample_fold_n = NULL,
  ...
)

\method{plot}{ResamplingSptCVCluto}(x, ...)

\method{plot}{ResamplingRepeatedSptCVCluto}(x, ...)
}
\arguments{
\item{object}{\verb{[Resampling]}\cr
mlr3 spatial resampling object of class \link{ResamplingSptCVCluto} or
\link{ResamplingRepeatedSptCVCluto}.}

\item{task}{\verb{[TaskClassifST]/[TaskRegrST]}\cr
mlr3 task object.}

\item{fold_id}{\verb{[numeric]}\cr
Fold IDs to plot.}

\item{plot_as_grid}{\verb{[logical(1)]}\cr
Should a gridded plot using via \CRANpkg{patchwork} be created? If \code{FALSE}
a list with of \CRANpkg{ggplot2} objects is returned.
Only applies if a numeric vector is passed to argument \code{fold_id}.}

\item{train_color}{\verb{[character(1)]}\cr
The color to use for the training set observations.}

\item{test_color}{\verb{[character(1)]}\cr
The color to use for the test set observations.}

\item{tickformat_date}{\verb{[character]}\cr
Date format for z-axis.}

\item{nticks_x}{\verb{[integer]}\cr
Number of x axis breaks. Only applies to SptCVCluto.}

\item{nticks_y}{\verb{[integer]}\cr
Number of y axis breaks. Only applies to SptCVCluto.}

\item{point_size}{\verb{[numeric]}\cr
Point size of markers.}

\item{axis_label_fontsize}{\verb{[integer]}\cr
Font size of axis labels.}

\item{sample_fold_n}{\verb{[integer]}\cr
Number of points in a random sample stratified over partitions.
This argument aims to keep file sizes of resulting plots reasonable and
reduce overplotting in dense datasets.}

\item{...}{Passed to \code{geom_sf()}. Helpful for adjusting point sizes and
shapes.}

\item{repeats_id}{\verb{[numeric]}\cr
Repetition ID to plot.}

\item{x}{\verb{[Resampling]}\cr
mlr3 spatial resampling object of class \link{ResamplingSptCVCluto} or
\link{ResamplingRepeatedSptCVCluto}.}
}
\description{
Generic S3 \code{plot()} and \code{autoplot()} (ggplot2) methods to
visualize mlr3 spatiotemporal resampling objects.
}
\examples{
\dontrun{
if (mlr3misc::require_namespaces(c("sf", "skmeans", "plotly"), quietly = TRUE)) {
  library(mlr3)
  library(mlr3spatiotempcv)
  task_st = tsk("cookfarm_mlr3")
  resampling = rsmp("sptcv_cluto", folds = 5)
  resampling$instantiate(task_st)

  # plot
  autoplot(resampling, task_st)
  autoplot(resampling, task_st, fold_id = 1)
  autoplot(resampling, task_st, fold_id = c(1, 2))
}
}
}
\seealso{
\itemize{
\item mlr3book chapter on \href{https://mlr3book.mlr-org.com/08-special-spatiotemp.html#vis-spt-partitions}{"Spatiotemporal Visualization"}
\item Vignette \href{https://mlr3spatiotempcv.mlr-org.com/articles/spatiotemp-viz.html}{Spatiotemporal Visualization}.
\item \code{\link[=autoplot.ResamplingSpCVBlock]{autoplot.ResamplingSpCVBlock()}}
\item \code{\link[=autoplot.ResamplingSpCVBuffer]{autoplot.ResamplingSpCVBuffer()}}
\item \code{\link[=autoplot.ResamplingSpCVCoords]{autoplot.ResamplingSpCVCoords()}}
\item \code{\link[=autoplot.ResamplingSpCVEnv]{autoplot.ResamplingSpCVEnv()}}
\item \code{\link[=autoplot.ResamplingSpCVDisc]{autoplot.ResamplingSpCVDisc()}}
\item \code{\link[=autoplot.ResamplingSpCVTiles]{autoplot.ResamplingSpCVTiles()}}
\item \code{\link[=autoplot.ResamplingCV]{autoplot.ResamplingCV()}}
\item \code{\link[=autoplot.ResamplingSptCVCstf]{autoplot.ResamplingSptCVCstf()}}
}
}
