% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSurvXuR2.R
\name{MeasureSurvXuR2}
\alias{MeasureSurvXuR2}
\alias{mlr_measures_surv.xuR2}
\title{Xu and O'Quigley's R2 Survival Measure}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{MeasureSurv}.}
\description{


Calls \code{\link[survAUC:XO]{survAUC::XO()}}.

Assumes Cox PH model specification.
}
\details{
All measures implemented from \CRANpkg{survAUC} should be used with care, we are aware
of problems in implementation that sometimes cause fatal errors in R. In future updates these
measures will all be re-written and implemented directly in \code{mlr3proba}.
}
\section{Construction}{
\preformatted{MeasureSurvXuR2$new()
mlr_measures$get("surv.xuR2")
msr("surv.xuR2")
}
}

\section{Meta Information}{

\itemize{
\item Type: \code{"surv"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{lp}
}
}

\section{Fields}{

See \link{MeasureSurv}, as well as all variables passed to the constructor.
}

\references{
\cite{mlr3proba}{xu_1999}
}
\seealso{
Other survival measures: 
\code{\link{MeasureSurvBeggC}},
\code{\link{MeasureSurvChamblessAUC}},
\code{\link{MeasureSurvGonenC}},
\code{\link{MeasureSurvGrafSE}},
\code{\link{MeasureSurvGraf}},
\code{\link{MeasureSurvHarrellC}},
\code{\link{MeasureSurvHungAUC}},
\code{\link{MeasureSurvIntLoglossSE}},
\code{\link{MeasureSurvIntLogloss}},
\code{\link{MeasureSurvLoglossSE}},
\code{\link{MeasureSurvLogloss}},
\code{\link{MeasureSurvNagelkR2}},
\code{\link{MeasureSurvOQuigleyR2}},
\code{\link{MeasureSurvSongAUC}},
\code{\link{MeasureSurvSongTNR}},
\code{\link{MeasureSurvSongTPR}},
\code{\link{MeasureSurvUnoAUC}},
\code{\link{MeasureSurvUnoC}},
\code{\link{MeasureSurvUnoTNR}},
\code{\link{MeasureSurvUnoTPR}}

Other R2 survival measures: 
\code{\link{MeasureSurvNagelkR2}},
\code{\link{MeasureSurvOQuigleyR2}}
}
\concept{R2 survival measures}
\concept{survival measures}
