% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpImpute.R
\name{PipeOpImpute}
\alias{PipeOpImpute}
\title{PipeOpImpute}
\format{Abstract \code{\link{R6Class}} object inheriting from \code{\link{PipeOp}}.}
\description{
Abstract base class for feature imputation.
}
\section{Construction}{
\preformatted{PipeOpImpute$$new(id, param_set = ParamSet$new(), param_vals = list(), whole_task_dependent = FALSE, packages = character(0), task_type = "Task")
}
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier of resulting object. See \verb{$id} slot of \code{\link{PipeOp}}.
\item \code{param_set} :: \code{\link[paradox:ParamSet]{ParamSet}}\cr
Parameter space description. This should be created by the subclass and given to \code{super$initialize()}.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings given in \code{param_set}. The
subclass should have its own \code{param_vals} parameter and pass it on to \code{super$initialize()}. Default \code{list()}.
\item \code{whole_task_dependent} :: \code{logical(1)}\cr
Whether the \code{context_columns} parameter should be added which lets the user limit the columns that are
used for imputation inference. This should generally be \code{FALSE} if imputation depends only on individual features
(e.g. mode imputation), and \code{TRUE} if imputation depends on other features as well (e.g. kNN-imputation).
\item packages :: \code{character}\cr
Set of all required packages for the \code{\link{PipeOp}}'s \verb{$train} and \verb{$predict} methods. See \verb{$packages} slot.
Default is \code{character(0)}.
\item \code{task_type} :: \code{character(1)}\cr
The class of \code{\link[mlr3:Task]{Task}} that should be accepted as input and will be returned as output. This
should generally be a \code{character(1)} identifying a type of \code{\link[mlr3:Task]{Task}}, e.g. \code{"Task"}, \code{"TaskClassif"} or
\code{"TaskRegr"} (or another subclass introduced by other packages). Default is \code{"Task"}.
}
}

\section{Input and Output Channels}{

\code{\link{PipeOpImpute}} has one input channel named \code{"input"}, taking a \code{\link[mlr3:Task]{Task}}, or a subclass of
\code{\link[mlr3:Task]{Task}} if the \code{task_type} construction argument is given as such; both during training and prediction.

\code{\link{PipeOpImpute}} has one output channel named \code{"output"}, producing a \code{\link[mlr3:Task]{Task}}, or a subclass;
the \code{\link[mlr3:Task]{Task}} type is the same as for input; both during training and prediction.

The output \code{\link[mlr3:Task]{Task}} is the modified input \code{\link[mlr3:Task]{Task}} with features imputed according to the \verb{$impute()} function.
}

\section{State}{

The \verb{$state} is a named \code{list}; besides members added by inheriting classes, the members are:
\itemize{
\item \code{affect_cols} :: \code{character}\cr
Names of features being selected by the \code{affect_columns} parameter.
\item \code{inference_cols} :: \code{character}\cr
Names of features being selected by the \code{context_columns} parameter.
\item \code{intasklayout} :: \code{\link{data.table}}\cr
Copy of the training \code{\link[mlr3:Task]{Task}}'s \verb{$feature_types} slot. This is used during prediction to ensure that
the prediction \code{\link[mlr3:Task]{Task}} has the same features, feature layout, and feature types as during training.
\item \code{outtasklayout} :: \code{\link{data.table}}\cr
Copy of the trained \code{\link[mlr3:Task]{Task}}'s \verb{$feature_types} slot. This is used during prediction to ensure that
the \code{\link[mlr3:Task]{Task}} resulting from the prediction operation has the same features, feature layout, and feature types as after training.
\item \code{model} :: named \code{list}\cr
Model used for imputation. This is a list named by \code{\link[mlr3:Task]{Task}} features, containing the result of the \verb{$train_imputer()} function for each one.
}
}

\section{Parameters}{

\itemize{
\item \code{affect_columns} :: \code{function} | \code{\link{Selector}} | \code{NULL} \cr
What columns the \code{\link{PipeOpImpute}} should operate on.
The parameter must be a \code{\link{Selector}} function, which takes a \code{\link[mlr3:Task]{Task}} as argument and returns a \code{character}
of features to use.\cr
See \code{\link{Selector}} for example functions. Defaults to \code{NULL}, which selects all features.
\item \code{context_columns} :: \code{function} | \code{\link{Selector}} | \code{NULL} \cr
What columns the \code{\link{PipeOpImpute}} imputation may depend on. This parameter is only present if the constructor is called with
the \code{whole_task_dependent} argument set to \code{TRUE}.\cr
The parameter must be a \code{\link{Selector}} function, which takes a \code{\link[mlr3:Task]{Task}} as argument and returns a \code{character}
of features to use.\cr
See \code{\link{Selector}} for example functions. Defaults to \code{NULL}, which selects all features.
}
}

\section{Internals}{

\code{\link{PipeOpImpute}} is an abstract class inheriting from \code{\link{PipeOp}} that makes implementing imputer \code{\link{PipeOp}}s simple.
}

\section{Fields}{

Fields inherited from \code{\link{PipeOp}}.
}

\section{Methods}{

Methods inherited from \code{\link{PipeOp}}, as well as:
\itemize{
\item \code{select_cols(task)} \cr
(\code{\link[mlr3:Task]{Task}}) -> \code{character} \cr
Selects which columns the \code{\link{PipeOp}} operates on. In contrast to
the \code{affect_columns} parameter. \code{select_cols} is for the \emph{inheriting class} to determine which columns
the operator should function on, e.g. based on feature type, while \code{affect_columns} is a way for the \emph{user}
to limit the columns that a \code{\link{PipeOpTaskPreproc}} should operate on.
\item \code{train_imputer(feature, type, context)}\cr
(\code{atomic}, \code{character(1)}, \code{\link{data.table}}) -> \code{any}\cr
Called once for each feature selected by \code{affect_columns} to create the model entry to be used for \verb{$impute()}.
\item \code{impute(feature, type, model, context)}\cr
(\code{atomic}, \code{character(1)}, \code{any}, \code{\link{data.table}}) -> \code{atomic}\cr
Imputes the features. \code{model} is the model created by \verb{$train_imputer()}
}
}

\seealso{
Other PipeOps: 
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOp}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputenewlvl}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_yeojohnson}},
\code{\link{mlr_pipeops}}

Other Imputation PipeOps: 
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputenewlvl}},
\code{\link{mlr_pipeops_imputesample}}
}
\concept{Imputation PipeOps}
\concept{PipeOps}
