test_that("as_short_string", {
  expect_equal(as_short_string(1L), "1")
  expect_equal(as_short_string(1.0), "1")
  expect_equal(as_short_string(1.23), "1.23")
  expect_equal(as_short_string(numeric(0)), "numeric(0)")
  expect_equal(as_short_string(factor(NULL)), "factor(0)")
  expect_equal(as_short_string(iris), "<data.frame>")
  expect_equal(as_short_string(NULL), "<NULL>")
  expect_equal(as_short_string(c(a=1, b=2)), "1,2")
  expect_equal(as_short_string(expression(a + b + 3)), "a + b + 3")
  expect_equal(as_short_string(list(a=1, 45)), "a=1, <unnamed>=45")
  expect_equal(as_short_string(list(a=1, b=list(x=3))), "a=1, b=<list>")
  expect_equal(as_short_string(list(a=1, b=iris)), "a=1, b=<data.frame>")

  expect_equal(as_short_string(list()), "list()")
  expect_equal(as_short_string(list(a=1)), "a=1")
  expect_equal(as_short_string(list(a=1:2)), "a=1,2")
  # expect_equal(as_short_string(list(a=1:20)), "a=1,2,3,4,5,6,...")
  expect_equal(as_short_string(list(a=1, 2, b=3)), "a=1, <unnamed>=2, b=3")
  expect_equal(as_short_string(list(a=1, 2, b=data.frame())), "a=1, <unnamed>=2, b=<data.frame>")
  expect_equal(as_short_string(list(a=identity, b=new.env(), c = NULL, d = expression(a + b + 3))), "a=<function>, b=<environment>, c=<NULL>, d=a + b + 3")

  expect_equal(as_short_string(list(a=1, b=3.2)), "a=1, b=3.2")
  expect_equal(as_short_string(list(a=1, b=3.223), num_format="%.2f"), "a=1.00, b=3.22")
  expect_equal(as_short_string(list(a=1L, b=3.223), num_format="%.2f"), "a=1, b=3.22")

  expect_equal(as_short_string(character(0)), "character(0)")
})
