% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cite_bib.R
\name{cite_bib}
\alias{cite_bib}
\title{Cite using a Bibtex File}
\usage{
cite_bib(package, key)
}
\arguments{
\item{package}{(\code{character(1)})\cr
Package to read the bibtex file from.}

\item{key}{(\code{character(1)})\cr
Entry of the bibtex file.
If the key is \code{"pkg::citation"}, the \code{\link[=citation]{citation()}} information of the package is used instead.
If the package provides multiple citation entries, a specific one can be selected by appending \code{"::n"} to the string \code{key} where \code{n} is the number of the citation entry (defaults to the first entry).}
}
\value{
(\code{character(1)}) Bibentry formated as Rd.
}
\description{
This function is called by the provided Rd macro \verb{\\\\cite\{pkg\}\{key\}}:
\itemize{
\item Parses the bibtex file \code{references.bib} in the root directory of package \code{package} using \code{\link[bibtex:read.bib]{bibtex::read.bib()}}.
\item Extracts the entry with key \code{key}.
\item Converts to Rd with \code{\link[tools:toRd]{tools::toRd()}}.
}
}
\examples{
# examplary bibtex file
path = system.file("references.bib", package = "mlr3misc")
cat(readLines(path), sep = "\n")

# bibtex entry as raw Rd
cite_bib("mlr3misc", "mlr")

# citation info as raw Rd
cite_bib("stats", "pkg::citation")
}
