% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_params.R
\name{set_params}
\alias{set_params}
\title{Modify Values of a Parameter Set}
\usage{
set_params(.ps, ..., .values = list(), .insert = TRUE)
}
\arguments{
\item{.ps}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
The parameter set whose values are changed.}

\item{...}{(\code{any})
Named parameter values.}

\item{.values}{(\code{list()})
Named list with parameter values.}

\item{.insert}{(\code{logical(1)})\cr
Whether to insert the values (old values are being kept, if not overwritten), or to discard the
old values. Is TRUE by default.}
}
\description{
Convenience function to modify (or overwrite) the values of a \link[paradox:ParamSet]{paradox::ParamSet}.
}
\examples{
if (requireNamespace("paradox")) {
  param_set = paradox::ps(a = paradox::p_dbl(), b = paradox::p_dbl())
  param_set$values$a = 0
  set_params(param_set, a = 1, .values = list(b = 2), .insert = TRUE)
  set_params(param_set, a = 3, .insert = FALSE)
  set_params(param_set, b = 4, .insert = TRUE)
}
}
