% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSelectorRFE.R
\name{mlr_fselectors_rfe}
\alias{mlr_fselectors_rfe}
\alias{FSelectorRFE}
\title{Feature Selection via Recursive Feature Elimination}
\description{
Recursive feature elimination iteratively removes features with a low importance score.

The learner is trained on all features at the start and importance scores are calculated for each feature (see section on optional extractors in \link{Learner}).
Then the least important feature is removed and the learner is trained on the reduced feature set.
The importance scores are calculated again and the procedure is repeated until the desired number of features is reached.
The non-recursive option (\code{recursive = FALSE}) only uses the importance scores calculated in the first iteration.

The feature selection terminates itself when \code{n_features} is reached.
It is not necessary to set a termination criterion.
}
\section{Dictionary}{

This \link{FSelector} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link{mlr_fselectors} or with the associated sugar function \code{\link[=fs]{fs()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_fselectors$get("rfe")
fs("rfe")
}\if{html}{\out{</div>}}
}

\section{Parameters}{

\describe{
\item{\code{n_features}}{\code{integer(1)}\cr
The number of features to select. By default half of the features are selected.}
\item{\code{feature_fraction}}{\code{double(1)}\cr
Fraction of features to retain in each iteration, The default 0.5 retrains half of the features.}
\item{\code{feature_number}}{\code{integer(1)}\cr
Number of features to remove in each iteration.}
\item{\code{subset_sizes}}{\code{integer()}\cr
Vector of number of features to retain in each iteration.
Must be sorted in decreasing order.}
\item{\code{recursive}}{\code{logical(1)}\cr
If \code{TRUE} (default), the feature importance is calculated in each iteration.}
}

The parameter \code{feature_fraction}, \code{feature_number} and \code{subset_sizes} are mutually exclusive.
}

\examples{
# retrieve task
task = tsk("pima")

# load learner
learner = lrn("classif.rpart")

\donttest{
# feature selection on the pima indians diabetes data set
instance = fselect(
  method = "rfe",
  task = task,
  learner = learner,
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
  store_models = TRUE
)

# best performing feature subset
instance$result

# all evaluated feature subsets
as.data.table(instance$archive)

# subset the task and fit the final model
task$select(instance$result_feature_set)
learner$train(task)
}
}
\section{Super class}{
\code{\link[mlr3fselect:FSelector]{mlr3fselect::FSelector}} -> \code{FSelectorRFE}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{importance}}{\code{numeric()}\cr
Stores the feature importance of the model with all variables if \code{recursive} is set to \code{FALSE}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FSelectorRFE-new}{\code{FSelectorRFE$new()}}
\item \href{#method-FSelectorRFE-clone}{\code{FSelectorRFE$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="format"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-format'><code>mlr3fselect::FSelector$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="help"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-help'><code>mlr3fselect::FSelector$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="optimize"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-optimize'><code>mlr3fselect::FSelector$optimize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="print"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-print'><code>mlr3fselect::FSelector$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectorRFE-new"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectorRFE-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorRFE$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectorRFE-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectorRFE-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorRFE$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
