% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fairness_accuracy_tradeoff.R
\name{fairness_accuracy_tradeoff}
\alias{fairness_accuracy_tradeoff}
\title{Plot Fairness Accuracy Trade-offs}
\usage{
fairness_accuracy_tradeoff(object, ...)
}
\arguments{
\item{object}{(\link{PredictionClassif} | \link{BenchmarkResult} | \link{ResampleResult})\cr
The binary class prediction object that will be evaluated.
\itemize{
\item If provided a \link{PredictionClassif}.
Then only one point will indicate the accuracy and fairness metrics for the current predictions.
Requires also passing a \link{Task}.
\item If provided a \link{ResampleResult}.
Then the plot will compare the accuracy and fairness metrics for the same model,
but different resampling iterations  as well as the aggregate indicated by a cross.
\item If provided a \link{BenchmarkResult}.
Then the plot will compare the accuracy and fairness metrics for all models and all resampling iterations.
Points are colored according to the learner_id and faceted by task_id.
The aggregated score is indicated by a cross.
}}

\item{...}{Arguments to be passed to methods. Such as:
\itemize{
\item \code{fairness_measure} (\link{Measure})\cr
The fairness measures that will evaluated.
Default measure set to be \code{msr("fairness.fpr")}
\item \code{accuracy_measure} (\link{Measure})\cr
The accuracy measure that will evaluated.
Default measure set to be \link[mlr3:MeasureClassif]{msr("classif.acc")}.
\item \code{task} (\link{TaskClassif})\cr
The data task that contains the protected column, only required when the class of object is (\link{PredictionClassif})
}}
}
\value{
A 'ggplot2' object.
}
\description{
Provides visualization wrt. trade-offs between fairness and accuracy metrics across learners and
resampling iterations.
This can assist in gauging the optimal model from a set of options along with estimates of variance
(through individual resampling iterations).
}
\examples{
library(mlr3learners)
library(ggplot2)

# Setup the Fairness Measures and tasks
task = tsk("adult_train")$filter(1:500)
learner = lrn("classif.ranger", predict_type = "prob")
learner$train(task)
predictions = learner$predict(task)
design = benchmark_grid(
  tasks = task,
  learners = lrns(c("classif.ranger", "classif.rpart"),
    predict_type = "prob", predict_sets = c("train", "predict")),
  resamplings = rsmps("cv", folds = 3)
)

bmr = benchmark(design)
fairness_measure = msr("fairness.tpr")

fairness_accuracy_tradeoff(predictions, fairness_measure, task = task)
fairness_accuracy_tradeoff(bmr, fairness_measure)
}
