% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateFilterValues.R
\name{plotFilterValues}
\alias{plotFilterValues}
\title{Plot filter values using ggplot2.}
\usage{
plotFilterValues(fvalues, sort = "dec", n.show = 20L,
  feat.type.cols = FALSE)
}
\arguments{
\item{fvalues}{[\code{\link{FilterValues}}]\cr
Filter values.}

\item{sort}{[\code{character(1)}]\cr
Sort features like this.
\dQuote{dec} = decreasing, \dQuote{inc} = increasing, \dQuote{none} = no sorting.
Default is decreasing.}

\item{n.show}{[\code{integer(1)}]\cr
Number of features (maximal) to show.
Default is 20.}

\item{feat.type.cols}{[\code{logical(1)}]\cr
Colors for factor and numeric features.
\code{FALSE} means no colors.
Default is \code{FALSE}.}
}
\value{
ggplot2 plot object.
}
\description{
Plot filter values using ggplot2.
}
\examples{
fv = generateFilterValuesData(iris.task, method = "chi.squared")
plotFilterValues(fv)
}
\seealso{
Other filter: \code{\link{FilterValues}},
  \code{\link{filterFeatures}},
  \code{\link{generateFilterValuesData}},
  \code{\link{getFilterValues}},
  \code{\link{getFilteredFeatures}},
  \code{\link{makeFilterWrapper}},
  \code{\link{plotFilterValuesGGVIS}}

Other plot: \code{\link{plotBenchmarkResult}},
  \code{\link{plotBenchmarkSummary}},
  \code{\link{plotCalibration}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotFilterValuesGGVIS}},
  \code{\link{plotLearningCurveGGVIS}},
  \code{\link{plotLearningCurve}},
  \code{\link{plotPartialPredictionGGVIS}},
  \code{\link{plotPartialPrediction}},
  \code{\link{plotROCCurves}},
  \code{\link{plotROCRCurvesGGVIS}},
  \code{\link{plotROCRCurves}},
  \code{\link{plotRankMatrixAsBar}},
  \code{\link{plotThreshVsPerfGGVIS}},
  \code{\link{plotThreshVsPerf}}
}

