% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Learner_properties.R
\name{LearnerProperties}
\alias{LearnerProperties}
\alias{addProperties}
\alias{hasProperties}
\alias{removeProperties}
\alias{setProperties}
\title{Set, add, remove or query properties of learners}
\usage{
setProperties(learner, props)

addProperties(learner, props)

removeProperties(learner, props)

hasProperties(learner, props)
}
\arguments{
\item{learner}{[\code{\link{Learner}} | \code{character(1)}]\cr
The learner.
If you pass a string the learner will be created via \code{\link{makeLearner}}.}

\item{props}{[\code{character}]\cr
Vector of properties to set, add, remove or query.}
}
\value{
\code{setProperties}, \code{addProperties} and \code{removeProperties}
 return an updated \code{\link{Learner}}.
 \code{hasProperties} returns a logical vector of the same length of \code{props}.
}
\description{
Properties can be accessed with \code{learner$properties}, which returns a
character vector.
}
\seealso{
Other learner: \code{\link{Learner}},
  \code{\link{makeLearner}}; \code{\link{getHyperPars}};
  \code{\link{getParamSet}}; \code{\link{removeHyperPars}};
  \code{\link{setHyperPars}}; \code{\link{setId}};
  \code{\link{setPredictThreshold}};
  \code{\link{setPredictType}}; \code{\link{showHyperPars}}
}

