% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBMRRanksAsBarChart.R
\name{plotBMRRanksAsBarChart}
\alias{plotBMRRanksAsBarChart}
\title{Create a bar chart for ranks in a BenchmarkResult.}
\usage{
plotBMRRanksAsBarChart(bmr, measure = NULL, ties.method = "average",
  aggregation = "default", pos = "stack", order.lrns = NULL,
  order.tsks = NULL, pretty.names = TRUE)
}
\arguments{
\item{bmr}{(\link{BenchmarkResult})\cr
Benchmark result.}

\item{measure}{(\link{Measure})\cr
Performance measure.
Default is the first measure used in the benchmark experiment.}

\item{ties.method}{(\code{character(1)})\cr
See \link{rank} for details.}

\item{aggregation}{(\code{character(1)}) \cr
\dQuote{mean} or \dQuote{default}. See \link{getBMRAggrPerformances}
for details on \dQuote{default}.}

\item{pos}{(\code{character(1)})\cr
Optionally set how the bars are positioned in ggplot2.
Ranks are plotted on the x-axis.
\dQuote{tile} plots a heat map with \code{task} as the y-axis.
Allows identification of the performance in a special task.
\dQuote{stack} plots a stacked bar plot.
Allows for comparison of learners within and and across ranks.
\dQuote{dodge} plots a bar plot with bars next to each other instead
of stacked bars.}

\item{order.lrns}{(\code{character(n.learners)})\cr
Character vector with \code{learner.ids} in new order.}

\item{order.tsks}{(\code{character(n.tasks)})\cr
Character vector with \code{task.ids} in new order.}

\item{pretty.names}{(\code{logical(1)})\cr
Whether to use the short name of the learner instead of its ID in labels. Defaults to \code{TRUE}.}
}
\value{
ggplot2 plot object.
}
\description{
Plots a bar chart from the ranks of algorithms. Alternatively,
tiles can be plotted for every rank-task combination, see \code{pos}
for details. In all plot variants the ranks of the learning algorithms are displayed on
the x-axis. Areas are always colored according to the \code{learner.id}.
}
\examples{
# see benchmark
}
\seealso{
Other plot: \code{\link{createSpatialResamplingPlots}},
  \code{\link{plotBMRBoxplots}},
  \code{\link{plotBMRSummary}},
  \code{\link{plotCalibration}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotLearningCurve}},
  \code{\link{plotPartialDependence}},
  \code{\link{plotROCCurves}}, \code{\link{plotResiduals}},
  \code{\link{plotThreshVsPerf}}

Other benchmark: \code{\link{BenchmarkResult}},
  \code{\link{batchmark}}, \code{\link{benchmark}},
  \code{\link{convertBMRToRankMatrix}},
  \code{\link{friedmanPostHocTestBMR}},
  \code{\link{friedmanTestBMR}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{getBMRAggrPerformances}},
  \code{\link{getBMRFeatSelResults}},
  \code{\link{getBMRFilteredFeatures}},
  \code{\link{getBMRLearnerIds}},
  \code{\link{getBMRLearnerShortNames}},
  \code{\link{getBMRLearners}},
  \code{\link{getBMRMeasureIds}},
  \code{\link{getBMRMeasures}}, \code{\link{getBMRModels}},
  \code{\link{getBMRPerformances}},
  \code{\link{getBMRPredictions}},
  \code{\link{getBMRTaskDescs}},
  \code{\link{getBMRTaskIds}},
  \code{\link{getBMRTuneResults}},
  \code{\link{plotBMRBoxplots}},
  \code{\link{plotBMRSummary}},
  \code{\link{plotCritDifferences}},
  \code{\link{reduceBatchmarkResults}}
}
\concept{benchmark}
\concept{plot}
