% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R, R/resample_convenience.R
\name{resample}
\alias{resample}
\alias{crossval}
\alias{repcv}
\alias{holdout}
\alias{subsample}
\alias{bootstrapOOB}
\alias{bootstrapB632}
\alias{bootstrapB632plus}
\title{Fit models according to a resampling strategy.}
\usage{
resample(learner, task, resampling, measures, weights = NULL,
  models = FALSE, extract, keep.pred = TRUE, ...,
  show.info = getMlrOption("show.info"))

crossval(learner, task, iters = 10L, stratify = FALSE, measures,
  models = FALSE, keep.pred = TRUE, ...,
  show.info = getMlrOption("show.info"))

repcv(learner, task, folds = 10L, reps = 10L, stratify = FALSE, measures,
  models = FALSE, keep.pred = TRUE, ...,
  show.info = getMlrOption("show.info"))

holdout(learner, task, split = 2/3, stratify = FALSE, measures,
  models = FALSE, keep.pred = TRUE, ...,
  show.info = getMlrOption("show.info"))

subsample(learner, task, iters = 30, split = 2/3, stratify = FALSE,
  measures, models = FALSE, keep.pred = TRUE, ...,
  show.info = getMlrOption("show.info"))

bootstrapOOB(learner, task, iters = 30, stratify = FALSE, measures,
  models = FALSE, keep.pred = TRUE, ...,
  show.info = getMlrOption("show.info"))

bootstrapB632(learner, task, iters = 30, stratify = FALSE, measures,
  models = FALSE, keep.pred = TRUE, ...,
  show.info = getMlrOption("show.info"))

bootstrapB632plus(learner, task, iters = 30, stratify = FALSE, measures,
  models = FALSE, keep.pred = TRUE, ...,
  show.info = getMlrOption("show.info"))
}
\arguments{
\item{learner}{[\code{\link{Learner}} | \code{character(1)}]\cr
The learner.
If you pass a string the learner will be created via \code{\link{makeLearner}}.}

\item{task}{[\code{\link{Task}}]\cr
The task.}

\item{resampling}{[\code{\link{ResampleDesc}} or \code{\link{ResampleInstance}}]\cr
Resampling strategy.
If a description is passed, it is instantiated automatically.}

\item{measures}{[\code{\link{Measure}} | list of \code{\link{Measure}}]\cr
Performance measure(s) to evaluate.
Default is the default measure for the task, see here \code{\link{getDefaultMeasure}}.}

\item{weights}{[\code{numeric}]\cr
Optional, non-negative case weight vector to be used during fitting.
If given, must be of same length as observations in task and in corresponding order.
Overwrites weights specified in the \code{task}.
By default \code{NULL} which means no weights are used unless specified in the task.}

\item{models}{[\code{logical(1)}]\cr
Should all fitted models be returned?
Default is \code{FALSE}.}

\item{extract}{[\code{function}]\cr
Function used to extract information from a fitted model during resampling.
Is applied to every \code{\link{WrappedModel}} resulting from calls to \code{\link{train}}
during resampling.
Default is to extract nothing.}

\item{keep.pred}{[\code{logical(1)}]\cr
Keep the prediction data in the \code{pred} slot of the result object.
If you do many experiments (on larger data sets) these objects might unnecessarily increase
object size / mem usage, if you do not really need them.
In this case you can set this argument to \code{FALSE}.
Default is \code{TRUE}.}

\item{...}{[any]\cr
Further hyperparameters passed to \code{learner}.}

\item{show.info}{[\code{logical(1)}]\cr
Print verbose output on console?
Default is set via \code{\link{configureMlr}}.}

\item{iters}{[\code{integer(1)}]\cr
See \code{\link{ResampleDesc}}.}

\item{stratify}{[\code{logical(1)}]\cr
See \code{\link{ResampleDesc}}.}

\item{folds}{[\code{integer(1)}]\cr
See \code{\link{ResampleDesc}}.}

\item{reps}{[\code{integer(1)}]\cr
See \code{\link{ResampleDesc}}.}

\item{split}{[\code{numeric(1)}]\cr
See \code{\link{ResampleDesc}}.}
}
\value{
[\code{\link{ResampleResult}}].
}
\description{
The function \code{resample} fits a model specified by \link{Learner} on a \link{Task}
and calculates predictions and performance \link{measures} for all training
and all test sets specified by a either a resampling description (\link{ResampleDesc})
or resampling instance (\link{ResampleInstance}).

You are able to return all fitted models (parameter \code{models}) or extract specific parts
of the models (parameter \code{extract}) as returning all of them completely
might be memory intensive.

The remaining functions on this page are convenience wrappers for the various
existing resampling strategies. Note that if you need to work with precomputed training and
test splits (i.e., resampling instances), you have to stick with \code{resample}.
}
\note{
If you would like to include results from the training data set, make
sure to appropriately adjust the resampling strategy and the aggregation for
the measure. See example code below.
}
\examples{
task = makeClassifTask(data = iris, target = "Species")
rdesc = makeResampleDesc("CV", iters = 2)
r = resample(makeLearner("classif.qda"), task, rdesc)
print(r$aggr)
print(r$measures.test)
print(r$pred)

# include the training set performance as well
rdesc = makeResampleDesc("CV", iters = 2, predict = "both")
r = resample(makeLearner("classif.qda"), task, rdesc,
  measures = list(mmce, setAggregation(mmce, train.mean)))
print(r$aggr)
}
\seealso{
Other resample: \code{\link{ResamplePrediction}},
  \code{\link{ResampleResult}}, \code{\link{addRRMeasure}},
  \code{\link{getRRPredictionList}},
  \code{\link{getRRPredictions}},
  \code{\link{getRRTaskDescription}},
  \code{\link{makeResampleDesc}},
  \code{\link{makeResampleInstance}}
}
