% Generated by roxygen2 (4.0.1): do not edit by hand
\name{selectFeatures}
\alias{selectFeatures}
\title{Feature selection by wrapper approach.}
\usage{
selectFeatures(learner, task, resampling, measures, bit.names, bits.to.features,
  control, show.info = getMlrOption("show.info"))
}
\arguments{
\item{learner}{[\code{\link{Learner}} | \code{character(1)}]\cr
The learner.
If you pass a string the learner will be created via \code{\link{makeLearner}}.}

\item{task}{[\code{\link{SupervisedTask}}]\cr
The task.}

\item{resampling}{[\code{\link{ResampleInstance}} | \code{\link{ResampleDesc}}]\cr
Resampling strategy for feature selection. If you pass a description,
it is instantiated once at the beginning by default, so all points are evaluated on the same training/test sets.
If you want to change that behaviour, look at \code{\link{FeatSelControl}}.}

\item{measures}{[list of \code{\link{Measure}} | \code{\link{Measure}}]\cr
Performance measures to evaluate. The first measure, aggregated by the first aggregation function
is optimized, others are simply evaluated.}

\item{bit.names}{[character]\cr
Names of bits encoding the solutions. Also defines the total number of bits in the encoding.
Per default these are the feature names of the task.}

\item{bits.to.features}{[function(x, task)]\cr
Function which transforms an integer-0-1 vector into a character vector of selected features.
Per default a value of 1 in the ith bit selects the ith feature to be in the candidate solution.}

\item{control}{[see \code{\link{FeatSelControl}}]
Control object for search method.
Also selects the optimization algorithm for feature selection.}

\item{show.info}{[\code{logical(1)}]\cr
Print verbose output on console?
Default is set via \code{\link{configureMlr}}.}
}
\value{
[\code{\link{FeatSelResult}}].
}
\description{
Optimizes the features for a classification or regression problem by choosing a variable selection wrapper approach.
Allows for different optimization methods, such as forward search or a genetic algorithm.
You can select such an algorithm (and its settings)
by passing a corresponding control object. For a complete list of implemented algorithms look at the
subclasses of [\code{\link{FeatSelControl}}].

All algorithms operate on a 0-1-bit encoding of candidate solutions. Per default a single bit corresponds
to a single feature, but you are able to change this by using the arguments \code{bit.names}
and \code{bits.to.features}. Thus allowing you to switch on whole groups of features with a single bit.
}
\examples{
rdesc = makeResampleDesc("Holdout")
ctrl = makeFeatSelControlSequential(method = "sfs", maxit = NA)
res = selectFeatures("classif.rpart", iris.task, rdesc, control = ctrl)
analyzeFeatSelResult(res)
}
\seealso{
Other featsel: \code{\link{FeatSelControl}},
  \code{\link{FeatSelControlExhaustive}},
  \code{\link{FeatSelControlGA}},
  \code{\link{FeatSelControlRandom}},
  \code{\link{FeatSelControlSequential}},
  \code{\link{makeFeatSelControlExhaustive}},
  \code{\link{makeFeatSelControlGA}},
  \code{\link{makeFeatSelControlRandom}},
  \code{\link{makeFeatSelControlSequential}};
  \code{\link{analyzeFeatSelResult}};
  \code{\link{getFeatSelResult}};
  \code{\link{makeFeatSelWrapper}}
}

