% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmm_probability.R
\name{gmm_probability}
\alias{gmm_probability}
\title{GMM Probability Calculator}
\usage{
gmm_probability(input, input_model, verbose = FALSE)
}
\arguments{
\item{input}{Input matrix to calculate probabilities of (numeric
matrix).}

\item{input_model}{Input GMM to use as model (GMM).}

\item{verbose}{Display informational messages and the full list of
parameters and timers at the end of execution.  Default value "FALSE"
(logical).}
}
\value{
A list with several components:
\item{output}{Matrix to store calculated probabilities in (numeric
  matrix).}
}
\description{
A probability calculator for GMMs.  Given a pre-trained GMM and a set of
points, this can compute the probability that each point is from the given
GMM.
}
\details{
This program calculates the probability that given points came from a given
GMM (that is, P(X | gmm)).  The GMM is specified with the "input_model"
parameter, and the points are specified with the "input" parameter.  The
output probabilities may be saved via the "output" output parameter.
}
\examples{
# So, for example, to calculate the probabilities of each point in "points"
# coming from the pre-trained GMM "gmm", while storing those probabilities in
# "probs", the following command could be used:

\dontrun{
output <- gmm_probability(input_model=gmm, input=points)
probs <- output$output
}
}
\author{
mlpack developers
}
