% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmm_generate.R
\name{gmm_generate}
\alias{gmm_generate}
\title{GMM Sample Generator}
\usage{
gmm_generate(input_model, samples, seed = NA, verbose = FALSE)
}
\arguments{
\item{input_model}{Input GMM model to generate samples from (GMM).}

\item{samples}{Number of samples to generate (integer).}

\item{seed}{Random seed.  If 0, 'std::time(NULL)' is used.  Default
value "0" (integer).}

\item{verbose}{Display informational messages and the full list of
parameters and timers at the end of execution.  Default value "FALSE"
(logical).}
}
\value{
A list with several components:
\item{output}{Matrix to save output samples in (numeric matrix).}
}
\description{
A sample generator for pre-trained GMMs.  Given a pre-trained GMM, this can
sample new points randomly from that distribution.
}
\details{
This program is able to generate samples from a pre-trained GMM (use
gmm_train to train a GMM).  The pre-trained GMM must be specified with the
"input_model" parameter.  The number of samples to generate is specified by
the "samples" parameter.  Output samples may be saved with the "output"
output parameter.
}
\examples{
# The following command can be used to generate 100 samples from the
# pre-trained GMM "gmm" and store those generated samples in "samples":

\dontrun{
output <- gmm_generate(input_model=gmm, samples=100)
samples <- output$output
}
}
\author{
mlpack developers
}
