/**
 * @file src/approx_kfn.cpp
 *
 * This is an autogenerated file containing implementations of C++ functions to
 * be called by the R approx_kfn binding.
 */
#include <rcpp_mlpack.h>
#define BINDING_TYPE BINDING_TYPE_R
#include <mlpack/methods/approx_kfn/approx_kfn_main.cpp>

// [[Rcpp::export]]
void approx_kfn_mlpackMain()
{
  mlpackMain();
}

// Any implementations of methods for dealing with model pointers will be put
// below this comment, if needed.

// Get the pointer to a ApproxKFNModel parameter.
// [[Rcpp::export]]
SEXP IO_GetParamApproxKFNModelPtr(const std::string& paramName)
{
  return std::move((Rcpp::XPtr<ApproxKFNModel>) IO::GetParam<ApproxKFNModel*>(paramName));
}

// Set the pointer to a ApproxKFNModel parameter.
// [[Rcpp::export]]
void IO_SetParamApproxKFNModelPtr(const std::string& paramName, SEXP ptr)
{
  IO::GetParam<ApproxKFNModel*>(paramName) =  Rcpp::as<Rcpp::XPtr<ApproxKFNModel>>(ptr);
  IO::SetPassed(paramName);
}

// Serialize a ApproxKFNModel pointer.
// [[Rcpp::export]]
Rcpp::RawVector SerializeApproxKFNModelPtr(SEXP ptr)
{
  std::ostringstream oss;
  {
    boost::archive::binary_oarchive oa(oss);
    oa << boost::serialization::make_nvp("ApproxKFNModel",
          *Rcpp::as<Rcpp::XPtr<ApproxKFNModel>>(ptr));
  }

  Rcpp::RawVector raw_vec(oss.str().size());

  // Copy the string buffer so we can return one that won't get deallocated when
  // we exit this function.
  memcpy(&raw_vec[0], oss.str().c_str(), oss.str().size());
  raw_vec.attr("type") = "ApproxKFNModel";
  return raw_vec;
}

// Deserialize a ApproxKFNModel pointer.
// [[Rcpp::export]]
SEXP DeserializeApproxKFNModelPtr(Rcpp::RawVector str)
{
  ApproxKFNModel* ptr = new ApproxKFNModel();

  std::istringstream iss(std::string((char *) &str[0], str.size()));
  {
    boost::archive::binary_iarchive ia(iss);
    ia >> boost::serialization::make_nvp("ApproxKFNModel", *ptr);
  }

  // R will be responsible for freeing this.
  return std::move((Rcpp::XPtr<ApproxKFNModel>)ptr);
}


