#'
#' @title DuckDuckGeese_1
#' @description Multivariate time series (MTS) of five species of geese.
#' @usage data(DuckDuckGeese_1)
#' @format A \code{list} with two elements, which are:
#' \describe{
#' \item{\code{data}}{A list with 50 MTS.}
#' \item{\code{classes}}{A numeric vector indicating the corresponding classes associated with the elements in \code{data}.}
#' }
#' @details Each element in \code{data} is a matrix formed by 270 rows (time points) indicating frequency and 1345 columns (variables) indicating recording.
#' The first 50 elements
#' of the whole dataset are stored here. All these elements pertain to the training set. The numeric vector \code{classes} is formed
#' by integers from 1 to 5, indicating that there are 5 different classes in the database. Each class is associated with a different
#' species of geese. For more information, \insertCite{bagnall2018uea;textual}{mlmts}.
#' Run "install.packages("ueadata3", repos="https://anloor7.github.io/drat")"
#' to access this dataset and use the syntax "ueadata3::DuckDuckGeese_1".
#' @references{
#'
#'   \insertRef{bagnall2018uea}{mlmts}
#'
#'   \insertRef{ruiz2021great}{mlmts}
#'
#'   \insertRef{bagnallweb}{mlmts}
#'
#' }
"DuckDuckGeese_1"

