% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dis_eucl.R
\encoding{UTF-8}
\name{dis_eucl}
\alias{dis_eucl}
\title{Constructs a pairwise distance matrix based on the Euclidean distance}
\usage{
dis_eucl(X)
}
\arguments{
\item{X}{A list of MTS (numerical matrices).}
}
\value{
The computed pairwise distance matrix.
}
\description{
\code{dis_eucl} returns a pairwise distance matrix based on the Euclidean distance
between MTS
}
\details{
Given a collection of MTS, the function returns the pairwise distance matrix,
where the distance between two MTS is defined as the sum of the standard
Euclidean distances between each corresponding pair of dimensions (univariate
time series)
}
\examples{
toy_dataset <- AtrialFibrillation$data[1 : 10] # Selecting the first 10 MTS from the
# dataset AtrialFibrillation
distance_matrix <- dis_eucl(toy_dataset) # Computing the pairwise
# distance matrix based on the distance dis_eucl
}
\author{
Ángel López-Oriona, José A. Vilar
}
