#'
#' @title Handwriting
#' @description Multivariate time series (MTS) indicating writing from a subject wearing a smartwatch.
#' @usage data(Handwriting)
#' @format A \code{list} with two elements, which are:
#' \describe{
#' \item{\code{data}}{A list with 1000 MTS.}
#' \item{\code{classes}}{A numeric vector indicating the corresponding classes associated with the elements in \code{data}.}
#' }
#' @details Each element in \code{data} is a matrix formed by 152 rows (time points) indicating acceleration trajectory and 3 columns (variables) indicating accelerometer value. The first 150 elements
#' correspond to the training set, whereas the last 850 elements correspond to the test set. The numeric vector \code{classes} is formed
#' by integers from 1 to 26, indicating that there are 26 different classes in the database. Each class is associated with a different
#' alphabetical character. For more information, see \insertCite{bagnall2018uea;textual}{mlmts}.
#' Run "install.packages("ueadata1", repos="https://anloor7.github.io/drat")"
#' to access this dataset and use the syntax "ueadata1::Handwriting".
#' @references{
#'
#'   \insertRef{bagnall2018uea}{mlmts}
#'
#'   \insertRef{ruiz2021great}{mlmts}
#'
#'   \insertRef{bagnallweb}{mlmts}
#'
#' }
"Handwriting"

